<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BalanceInfoRsp StructType
 * @subpackage Structs
 */
class BalanceInfoRsp extends AbstractStructBase
{
    /**
     * The balanceAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $balanceAmount;
    /**
     * The balanceShow
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $balanceShow;
    /**
     * The measureId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $measureId;
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * Constructor method for BalanceInfoRsp
     * @uses BalanceInfoRsp::setBalanceAmount()
     * @uses BalanceInfoRsp::setBalanceShow()
     * @uses BalanceInfoRsp::setMeasureId()
     * @uses BalanceInfoRsp::setRespCode()
     * @uses BalanceInfoRsp::setRespDesc()
     * @param string $balanceAmount
     * @param string $balanceShow
     * @param string $measureId
     * @param string $respCode
     * @param string $respDesc
     */
    public function __construct($balanceAmount = null, $balanceShow = null, $measureId = null, $respCode = null, $respDesc = null)
    {
        $this
            ->setBalanceAmount($balanceAmount)
            ->setBalanceShow($balanceShow)
            ->setMeasureId($measureId)
            ->setRespCode($respCode)
            ->setRespDesc($respDesc);
    }
    /**
     * Get balanceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBalanceAmount()
    {
        return isset($this->balanceAmount) ? $this->balanceAmount : null;
    }
    /**
     * Set balanceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $balanceAmount
     * @return \Payktm\StructType\BalanceInfoRsp
     */
    public function setBalanceAmount($balanceAmount = null)
    {
        // validation for constraint: string
        if (!is_null($balanceAmount) && !is_string($balanceAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceAmount)), __LINE__);
        }
        if (is_null($balanceAmount) || (is_array($balanceAmount) && empty($balanceAmount))) {
            unset($this->balanceAmount);
        } else {
            $this->balanceAmount = $balanceAmount;
        }
        return $this;
    }
    /**
     * Get balanceShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBalanceShow()
    {
        return isset($this->balanceShow) ? $this->balanceShow : null;
    }
    /**
     * Set balanceShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $balanceShow
     * @return \Payktm\StructType\BalanceInfoRsp
     */
    public function setBalanceShow($balanceShow = null)
    {
        // validation for constraint: string
        if (!is_null($balanceShow) && !is_string($balanceShow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceShow)), __LINE__);
        }
        if (is_null($balanceShow) || (is_array($balanceShow) && empty($balanceShow))) {
            unset($this->balanceShow);
        } else {
            $this->balanceShow = $balanceShow;
        }
        return $this;
    }
    /**
     * Get measureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMeasureId()
    {
        return isset($this->measureId) ? $this->measureId : null;
    }
    /**
     * Set measureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $measureId
     * @return \Payktm\StructType\BalanceInfoRsp
     */
    public function setMeasureId($measureId = null)
    {
        // validation for constraint: string
        if (!is_null($measureId) && !is_string($measureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measureId)), __LINE__);
        }
        if (is_null($measureId) || (is_array($measureId) && empty($measureId))) {
            unset($this->measureId);
        } else {
            $this->measureId = $measureId;
        }
        return $this;
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\BalanceInfoRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\BalanceInfoRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\BalanceInfoRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
