<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Un ServiceType
 * @subpackage Services
 */
class Un extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named unSelectServiceQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\UnSelectServiceQuery $parameters
     * @return \Payktm\StructType\UnSelectServiceQueryResponse|bool
     */
    public function unSelectServiceQuery(\Payktm\StructType\UnSelectServiceQuery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->unSelectServiceQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\UnSelectServiceQueryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
