<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getDealerBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\GetDealerBalance $parameters
     * @return \Payktm\StructType\GetDealerBalanceResponse|bool
     */
    public function getDealerBalance(\Payktm\StructType\GetDealerBalance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDealerBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStaticDataByCodeType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\GetStaticDataByCodeType $parameters
     * @return \Payktm\StructType\GetStaticDataByCodeTypeResponse|bool
     */
    public function getStaticDataByCodeType(\Payktm\StructType\GetStaticDataByCodeType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getStaticDataByCodeType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSRECardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\GetSRECardInfo $parameters
     * @return \Payktm\StructType\GetSRECardInfoResponse|bool
     */
    public function getSRECardInfo(\Payktm\StructType\GetSRECardInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSRECardInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDealerSaleCardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\GetDealerSaleCardInfo $parameters
     * @return \Payktm\StructType\GetDealerSaleCardInfoResponse|bool
     */
    public function getDealerSaleCardInfo(\Payktm\StructType\GetDealerSaleCardInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDealerSaleCardInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDealerCardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\GetDealerCardInfo $parameters
     * @return \Payktm\StructType\GetDealerCardInfoResponse|bool
     */
    public function getDealerCardInfo(\Payktm\StructType\GetDealerCardInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDealerCardInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllOrganize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\GetAllOrganize $parameters
     * @return \Payktm\StructType\GetAllOrganizeResponse|bool
     */
    public function getAllOrganize(\Payktm\StructType\GetAllOrganize $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAllOrganize($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\GetAllOrganizeResponse|\Payktm\StructType\GetDealerBalanceResponse|\Payktm\StructType\GetDealerCardInfoResponse|\Payktm\StructType\GetDealerSaleCardInfoResponse|\Payktm\StructType\GetSRECardInfoResponse|\Payktm\StructType\GetStaticDataByCodeTypeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
