<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ET ServiceType
 * @subpackage Services
 */
class ET extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named eTopupModify
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\ETopupModify $parameters
     * @return \Payktm\StructType\ETopupModifyResponse|bool
     */
    public function eTopupModify(\Payktm\StructType\ETopupModify $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eTopupModify($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named eTopupThresholdCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\ETopupThresholdCheck $parameters
     * @return \Payktm\StructType\ETopupThresholdCheckResponse|bool
     */
    public function eTopupThresholdCheck(\Payktm\StructType\ETopupThresholdCheck $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eTopupThresholdCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named eTopupRecordQuery2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\ETopupRecordQuery2 $parameters
     * @return \Payktm\StructType\ETopupRecordQuery2Response|bool
     */
    public function eTopupRecordQuery2(\Payktm\StructType\ETopupRecordQuery2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eTopupRecordQuery2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named eTopupRecordQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\ETopupRecordQuery $parameters
     * @return \Payktm\StructType\ETopupRecordQueryResponse|bool
     */
    public function eTopupRecordQuery(\Payktm\StructType\ETopupRecordQuery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eTopupRecordQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named eTopupTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\ETopupTransfer $parameters
     * @return \Payktm\StructType\ETopupTransferResponse|bool
     */
    public function eTopupTransfer(\Payktm\StructType\ETopupTransfer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eTopupTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named eTopupRollback
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\ETopupRollback $parameters
     * @return \Payktm\StructType\ETopupRollbackResponse|bool
     */
    public function eTopupRollback(\Payktm\StructType\ETopupRollback $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eTopupRollback($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\ETopupModifyResponse|\Payktm\StructType\ETopupRecordQuery2Response|\Payktm\StructType\ETopupRecordQueryResponse|\Payktm\StructType\ETopupRollbackResponse|\Payktm\StructType\ETopupThresholdCheckResponse|\Payktm\StructType\ETopupTransferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
