<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteRetailers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DeleteRetailers $parameters
     * @return \Payktm\StructType\DeleteRetailersResponse|bool
     */
    public function deleteRetailers(\Payktm\StructType\DeleteRetailers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteRetailers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteServiceInfoSave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DeleteServiceInfoSave $parameters
     * @return \Payktm\StructType\DeleteServiceInfoSaveResponse|bool
     */
    public function deleteServiceInfoSave(\Payktm\StructType\DeleteServiceInfoSave $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteServiceInfoSave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\DeleteRetailersResponse|\Payktm\StructType\DeleteServiceInfoSaveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
