<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dealer ServiceType
 * @subpackage Services
 */
class Dealer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named dealerAllInfoQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerAllInfoQuery $parameters
     * @return \Payktm\StructType\DealerAllInfoQueryResponse|bool
     */
    public function dealerAllInfoQuery(\Payktm\StructType\DealerAllInfoQuery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerAllInfoQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerServiceInfoUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerServiceInfoUpdate $parameters
     * @return \Payktm\StructType\DealerServiceInfoUpdateResponse|bool
     */
    public function dealerServiceInfoUpdate(\Payktm\StructType\DealerServiceInfoUpdate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerServiceInfoUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerInfoModify
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerInfoModify $parameters
     * @return \Payktm\StructType\DealerInfoModifyResponse|bool
     */
    public function dealerInfoModify(\Payktm\StructType\DealerInfoModify $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerInfoModify($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerFileInfoSave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerFileInfoSave $parameters
     * @return \Payktm\StructType\DealerFileInfoSaveResponse|bool
     */
    public function dealerFileInfoSave(\Payktm\StructType\DealerFileInfoSave $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerFileInfoSave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerServiceMaxQTYQry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerServiceMaxQTYQry $parameters
     * @return \Payktm\StructType\DealerServiceMaxQTYQryResponse|bool
     */
    public function dealerServiceMaxQTYQry(\Payktm\StructType\DealerServiceMaxQTYQry $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerServiceMaxQTYQry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerFileInfoUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerFileInfoUpdate $parameters
     * @return \Payktm\StructType\DealerFileInfoUpdateResponse|bool
     */
    public function dealerFileInfoUpdate(\Payktm\StructType\DealerFileInfoUpdate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerFileInfoUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerServiceInfoSave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerServiceInfoSave $parameters
     * @return \Payktm\StructType\DealerServiceInfoSaveResponse|bool
     */
    public function dealerServiceInfoSave(\Payktm\StructType\DealerServiceInfoSave $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerServiceInfoSave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerApplySave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerApplySave $parameters
     * @return \Payktm\StructType\DealerApplySaveResponse|bool
     */
    public function dealerApplySave(\Payktm\StructType\DealerApplySave $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerApplySave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerFileInfoDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerFileInfoDelete $parameters
     * @return \Payktm\StructType\DealerFileInfoDeleteResponse|bool
     */
    public function dealerFileInfoDelete(\Payktm\StructType\DealerFileInfoDelete $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerFileInfoDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerPasswordChg
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerPasswordChg $parameters
     * @return \Payktm\StructType\DealerPasswordChgResponse|bool
     */
    public function dealerPasswordChg(\Payktm\StructType\DealerPasswordChg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerPasswordChg($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerInfoQueryByContactPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerInfoQueryByContactPhone $parameters
     * @return \Payktm\StructType\DealerInfoQueryByContactPhoneResponse|bool
     */
    public function dealerInfoQueryByContactPhone(\Payktm\StructType\DealerInfoQueryByContactPhone $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerInfoQueryByContactPhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerTradePasswordChg
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerTradePasswordChg $parameters
     * @return \Payktm\StructType\DealerTradePasswordChgResponse|bool
     */
    public function dealerTradePasswordChg(\Payktm\StructType\DealerTradePasswordChg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerTradePasswordChg($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerInfoQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerInfoQuery $parameters
     * @return \Payktm\StructType\DealerInfoQueryResponse|bool
     */
    public function dealerInfoQuery(\Payktm\StructType\DealerInfoQuery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerInfoQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dealerFileInfoQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\DealerFileInfoQuery $parameters
     * @return \Payktm\StructType\DealerFileInfoQueryResponse|bool
     */
    public function dealerFileInfoQuery(\Payktm\StructType\DealerFileInfoQuery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dealerFileInfoQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\DealerAllInfoQueryResponse|\Payktm\StructType\DealerApplySaveResponse|\Payktm\StructType\DealerFileInfoDeleteResponse|\Payktm\StructType\DealerFileInfoQueryResponse|\Payktm\StructType\DealerFileInfoSaveResponse|\Payktm\StructType\DealerFileInfoUpdateResponse|\Payktm\StructType\DealerInfoModifyResponse|\Payktm\StructType\DealerInfoQueryByContactPhoneResponse|\Payktm\StructType\DealerInfoQueryResponse|\Payktm\StructType\DealerPasswordChgResponse|\Payktm\StructType\DealerServiceInfoSaveResponse|\Payktm\StructType\DealerServiceInfoUpdateResponse|\Payktm\StructType\DealerServiceMaxQTYQryResponse|\Payktm\StructType\DealerTradePasswordChgResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
