<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkMposNoIsRepeat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\CheckMposNoIsRepeat $parameters
     * @return \Payktm\StructType\CheckMposNoIsRepeatResponse|bool
     */
    public function checkMposNoIsRepeat(\Payktm\StructType\CheckMposNoIsRepeat $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkMposNoIsRepeat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkDealerPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\CheckDealerPassword $parameters
     * @return \Payktm\StructType\CheckDealerPasswordResponse|bool
     */
    public function checkDealerPassword(\Payktm\StructType\CheckDealerPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkDealerPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkDealerSalesBillId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\CheckDealerSalesBillId $parameters
     * @return \Payktm\StructType\CheckDealerSalesBillIdResponse|bool
     */
    public function checkDealerSalesBillId(\Payktm\StructType\CheckDealerSalesBillId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkDealerSalesBillId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkDealer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\CheckDealer $parameters
     * @return \Payktm\StructType\CheckDealerResponse|bool
     */
    public function checkDealer(\Payktm\StructType\CheckDealer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\CheckDealerPasswordResponse|\Payktm\StructType\CheckDealerResponse|\Payktm\StructType\CheckDealerSalesBillIdResponse|\Payktm\StructType\CheckMposNoIsRepeatResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
