<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecOrganizeRsp StructType
 * @subpackage Structs
 */
class SecOrganizeRsp extends AbstractStructBase
{
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * The secOrganize
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\SecOrganize[]
     */
    public $secOrganize;
    /**
     * Constructor method for SecOrganizeRsp
     * @uses SecOrganizeRsp::setRespCode()
     * @uses SecOrganizeRsp::setRespDesc()
     * @uses SecOrganizeRsp::setSecOrganize()
     * @param string $respCode
     * @param string $respDesc
     * @param \Payktm\StructType\SecOrganize[] $secOrganize
     */
    public function __construct($respCode = null, $respDesc = null, array $secOrganize = array())
    {
        $this
            ->setRespCode($respCode)
            ->setRespDesc($respDesc)
            ->setSecOrganize($secOrganize);
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\SecOrganizeRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\SecOrganizeRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Get secOrganize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\SecOrganize[]|null
     */
    public function getSecOrganize()
    {
        return isset($this->secOrganize) ? $this->secOrganize : null;
    }
    /**
     * Set secOrganize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\SecOrganize[] $secOrganize
     * @return \Payktm\StructType\SecOrganizeRsp
     */
    public function setSecOrganize(array $secOrganize = array())
    {
        foreach ($secOrganize as $secOrganizeRspSecOrganizeItem) {
            // validation for constraint: itemType
            if (!$secOrganizeRspSecOrganizeItem instanceof \Payktm\StructType\SecOrganize) {
                throw new \InvalidArgumentException(sprintf('The secOrganize property can only contain items of \Payktm\StructType\SecOrganize, "%s" given', is_object($secOrganizeRspSecOrganizeItem) ? get_class($secOrganizeRspSecOrganizeItem) : gettype($secOrganizeRspSecOrganizeItem)), __LINE__);
            }
        }
        if (is_null($secOrganize) || (is_array($secOrganize) && empty($secOrganize))) {
            unset($this->secOrganize);
        } else {
            $this->secOrganize = $secOrganize;
        }
        return $this;
    }
    /**
     * Add item to secOrganize value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\SecOrganize $item
     * @return \Payktm\StructType\SecOrganizeRsp
     */
    public function addToSecOrganize(\Payktm\StructType\SecOrganize $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\SecOrganize) {
            throw new \InvalidArgumentException(sprintf('The secOrganize property can only contain items of \Payktm\StructType\SecOrganize, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->secOrganize[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\SecOrganizeRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
