<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseHeader StructType
 * @subpackage Structs
 */
class ResponseHeader extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorCode;
    /**
     * The errorMsg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorMsg;
    /**
     * The finishDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $finishDate;
    /**
     * Constructor method for ResponseHeader
     * @uses ResponseHeader::setErrorCode()
     * @uses ResponseHeader::setErrorMsg()
     * @uses ResponseHeader::setFinishDate()
     * @param string $errorCode
     * @param string $errorMsg
     * @param string $finishDate
     */
    public function __construct($errorCode = null, $errorMsg = null, $finishDate = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMsg($errorMsg)
            ->setFinishDate($finishDate);
    }
    /**
     * Get errorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->errorCode) ? $this->errorCode : null;
    }
    /**
     * Set errorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \Payktm\StructType\ResponseHeader
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->errorCode);
        } else {
            $this->errorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get errorMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMsg()
    {
        return isset($this->errorMsg) ? $this->errorMsg : null;
    }
    /**
     * Set errorMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMsg
     * @return \Payktm\StructType\ResponseHeader
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMsg)), __LINE__);
        }
        if (is_null($errorMsg) || (is_array($errorMsg) && empty($errorMsg))) {
            unset($this->errorMsg);
        } else {
            $this->errorMsg = $errorMsg;
        }
        return $this;
    }
    /**
     * Get finishDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinishDate()
    {
        return isset($this->finishDate) ? $this->finishDate : null;
    }
    /**
     * Set finishDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finishDate
     * @return \Payktm\StructType\ResponseHeader
     */
    public function setFinishDate($finishDate = null)
    {
        // validation for constraint: string
        if (!is_null($finishDate) && !is_string($finishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finishDate)), __LINE__);
        }
        if (is_null($finishDate) || (is_array($finishDate) && empty($finishDate))) {
            unset($this->finishDate);
        } else {
            $this->finishDate = $finishDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\ResponseHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
