<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseCardRecall StructType
 * @subpackage Structs
 */
class ResponseCardRecall extends AbstractStructBase
{
    /**
     * The dealerCardInfoRsp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerCardInfoRsp
     */
    public $dealerCardInfoRsp;
    /**
     * The responseHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\ResponseHeader
     */
    public $responseHeader;
    /**
     * Constructor method for ResponseCardRecall
     * @uses ResponseCardRecall::setDealerCardInfoRsp()
     * @uses ResponseCardRecall::setResponseHeader()
     * @param \Payktm\StructType\DealerCardInfoRsp $dealerCardInfoRsp
     * @param \Payktm\StructType\ResponseHeader $responseHeader
     */
    public function __construct(\Payktm\StructType\DealerCardInfoRsp $dealerCardInfoRsp = null, \Payktm\StructType\ResponseHeader $responseHeader = null)
    {
        $this
            ->setDealerCardInfoRsp($dealerCardInfoRsp)
            ->setResponseHeader($responseHeader);
    }
    /**
     * Get dealerCardInfoRsp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerCardInfoRsp|null
     */
    public function getDealerCardInfoRsp()
    {
        return isset($this->dealerCardInfoRsp) ? $this->dealerCardInfoRsp : null;
    }
    /**
     * Set dealerCardInfoRsp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\DealerCardInfoRsp $dealerCardInfoRsp
     * @return \Payktm\StructType\ResponseCardRecall
     */
    public function setDealerCardInfoRsp(\Payktm\StructType\DealerCardInfoRsp $dealerCardInfoRsp = null)
    {
        if (is_null($dealerCardInfoRsp) || (is_array($dealerCardInfoRsp) && empty($dealerCardInfoRsp))) {
            unset($this->dealerCardInfoRsp);
        } else {
            $this->dealerCardInfoRsp = $dealerCardInfoRsp;
        }
        return $this;
    }
    /**
     * Get responseHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\ResponseHeader|null
     */
    public function getResponseHeader()
    {
        return isset($this->responseHeader) ? $this->responseHeader : null;
    }
    /**
     * Set responseHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\ResponseHeader $responseHeader
     * @return \Payktm\StructType\ResponseCardRecall
     */
    public function setResponseHeader(\Payktm\StructType\ResponseHeader $responseHeader = null)
    {
        if (is_null($responseHeader) || (is_array($responseHeader) && empty($responseHeader))) {
            unset($this->responseHeader);
        } else {
            $this->responseHeader = $responseHeader;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\ResponseCardRecall
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
