<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETopupRecordRsp StructType
 * @subpackage Structs
 */
class ETopupRecordRsp extends AbstractStructBase
{
    /**
     * The etopupRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\ETopupRecord[]
     */
    public $etopupRecord;
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * Constructor method for ETopupRecordRsp
     * @uses ETopupRecordRsp::setEtopupRecord()
     * @uses ETopupRecordRsp::setRespCode()
     * @uses ETopupRecordRsp::setRespDesc()
     * @param \Payktm\StructType\ETopupRecord[] $etopupRecord
     * @param string $respCode
     * @param string $respDesc
     */
    public function __construct(array $etopupRecord = array(), $respCode = null, $respDesc = null)
    {
        $this
            ->setEtopupRecord($etopupRecord)
            ->setRespCode($respCode)
            ->setRespDesc($respDesc);
    }
    /**
     * Get etopupRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\ETopupRecord[]|null
     */
    public function getEtopupRecord()
    {
        return isset($this->etopupRecord) ? $this->etopupRecord : null;
    }
    /**
     * Set etopupRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\ETopupRecord[] $etopupRecord
     * @return \Payktm\StructType\ETopupRecordRsp
     */
    public function setEtopupRecord(array $etopupRecord = array())
    {
        foreach ($etopupRecord as $eTopupRecordRspEtopupRecordItem) {
            // validation for constraint: itemType
            if (!$eTopupRecordRspEtopupRecordItem instanceof \Payktm\StructType\ETopupRecord) {
                throw new \InvalidArgumentException(sprintf('The etopupRecord property can only contain items of \Payktm\StructType\ETopupRecord, "%s" given', is_object($eTopupRecordRspEtopupRecordItem) ? get_class($eTopupRecordRspEtopupRecordItem) : gettype($eTopupRecordRspEtopupRecordItem)), __LINE__);
            }
        }
        if (is_null($etopupRecord) || (is_array($etopupRecord) && empty($etopupRecord))) {
            unset($this->etopupRecord);
        } else {
            $this->etopupRecord = $etopupRecord;
        }
        return $this;
    }
    /**
     * Add item to etopupRecord value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\ETopupRecord $item
     * @return \Payktm\StructType\ETopupRecordRsp
     */
    public function addToEtopupRecord(\Payktm\StructType\ETopupRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\ETopupRecord) {
            throw new \InvalidArgumentException(sprintf('The etopupRecord property can only contain items of \Payktm\StructType\ETopupRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->etopupRecord[] = $item;
        return $this;
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\ETopupRecordRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\ETopupRecordRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\ETopupRecordRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
