<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETopupRecordReq StructType
 * @subpackage Structs
 */
class ETopupRecordReq extends AbstractStructBase
{
    /**
     * The currentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currentNumber;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $endDate;
    /**
     * The operationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $operationType;
    /**
     * The parentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parentId;
    /**
     * The sourceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sourceNumber;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startDate;
    /**
     * The targetNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $targetNumber;
    /**
     * The transactionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transactionId;
    /**
     * The transferType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transferType;
    /**
     * Constructor method for ETopupRecordReq
     * @uses ETopupRecordReq::setCurrentNumber()
     * @uses ETopupRecordReq::setEndDate()
     * @uses ETopupRecordReq::setOperationType()
     * @uses ETopupRecordReq::setParentId()
     * @uses ETopupRecordReq::setSourceNumber()
     * @uses ETopupRecordReq::setStartDate()
     * @uses ETopupRecordReq::setTargetNumber()
     * @uses ETopupRecordReq::setTransactionId()
     * @uses ETopupRecordReq::setTransferType()
     * @param string $currentNumber
     * @param string $endDate
     * @param string $operationType
     * @param string $parentId
     * @param string $sourceNumber
     * @param string $startDate
     * @param string $targetNumber
     * @param string $transactionId
     * @param string $transferType
     */
    public function __construct($currentNumber = null, $endDate = null, $operationType = null, $parentId = null, $sourceNumber = null, $startDate = null, $targetNumber = null, $transactionId = null, $transferType = null)
    {
        $this
            ->setCurrentNumber($currentNumber)
            ->setEndDate($endDate)
            ->setOperationType($operationType)
            ->setParentId($parentId)
            ->setSourceNumber($sourceNumber)
            ->setStartDate($startDate)
            ->setTargetNumber($targetNumber)
            ->setTransactionId($transactionId)
            ->setTransferType($transferType);
    }
    /**
     * Get currentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentNumber()
    {
        return isset($this->currentNumber) ? $this->currentNumber : null;
    }
    /**
     * Set currentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentNumber
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setCurrentNumber($currentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($currentNumber) && !is_string($currentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentNumber)), __LINE__);
        }
        if (is_null($currentNumber) || (is_array($currentNumber) && empty($currentNumber))) {
            unset($this->currentNumber);
        } else {
            $this->currentNumber = $currentNumber;
        }
        return $this;
    }
    /**
     * Get endDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->endDate) ? $this->endDate : null;
    }
    /**
     * Set endDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->endDate);
        } else {
            $this->endDate = $endDate;
        }
        return $this;
    }
    /**
     * Get operationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationType()
    {
        return isset($this->operationType) ? $this->operationType : null;
    }
    /**
     * Set operationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationType
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationType)), __LINE__);
        }
        if (is_null($operationType) || (is_array($operationType) && empty($operationType))) {
            unset($this->operationType);
        } else {
            $this->operationType = $operationType;
        }
        return $this;
    }
    /**
     * Get parentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->parentId) ? $this->parentId : null;
    }
    /**
     * Set parentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentId)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->parentId);
        } else {
            $this->parentId = $parentId;
        }
        return $this;
    }
    /**
     * Get sourceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceNumber()
    {
        return isset($this->sourceNumber) ? $this->sourceNumber : null;
    }
    /**
     * Set sourceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceNumber
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setSourceNumber($sourceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sourceNumber) && !is_string($sourceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceNumber)), __LINE__);
        }
        if (is_null($sourceNumber) || (is_array($sourceNumber) && empty($sourceNumber))) {
            unset($this->sourceNumber);
        } else {
            $this->sourceNumber = $sourceNumber;
        }
        return $this;
    }
    /**
     * Get startDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->startDate) ? $this->startDate : null;
    }
    /**
     * Set startDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->startDate);
        } else {
            $this->startDate = $startDate;
        }
        return $this;
    }
    /**
     * Get targetNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetNumber()
    {
        return isset($this->targetNumber) ? $this->targetNumber : null;
    }
    /**
     * Set targetNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetNumber
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setTargetNumber($targetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($targetNumber) && !is_string($targetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetNumber)), __LINE__);
        }
        if (is_null($targetNumber) || (is_array($targetNumber) && empty($targetNumber))) {
            unset($this->targetNumber);
        } else {
            $this->targetNumber = $targetNumber;
        }
        return $this;
    }
    /**
     * Get transactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->transactionId) ? $this->transactionId : null;
    }
    /**
     * Set transactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionId)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->transactionId);
        } else {
            $this->transactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get transferType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransferType()
    {
        return isset($this->transferType) ? $this->transferType : null;
    }
    /**
     * Set transferType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transferType
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public function setTransferType($transferType = null)
    {
        // validation for constraint: string
        if (!is_null($transferType) && !is_string($transferType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transferType)), __LINE__);
        }
        if (is_null($transferType) || (is_array($transferType) && empty($transferType))) {
            unset($this->transferType);
        } else {
            $this->transferType = $transferType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\ETopupRecordReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
