<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerServiceMaxQTYReq StructType
 * @subpackage Structs
 */
class DealerServiceMaxQTYReq extends AbstractStructBase
{
    /**
     * The dealerLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dealerLevel;
    /**
     * The district
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $district;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $region;
    /**
     * The regionLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $regionLevel;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceType;
    /**
     * The zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $zone;
    /**
     * Constructor method for DealerServiceMaxQTYReq
     * @uses DealerServiceMaxQTYReq::setDealerLevel()
     * @uses DealerServiceMaxQTYReq::setDistrict()
     * @uses DealerServiceMaxQTYReq::setRegion()
     * @uses DealerServiceMaxQTYReq::setRegionLevel()
     * @uses DealerServiceMaxQTYReq::setServiceType()
     * @uses DealerServiceMaxQTYReq::setZone()
     * @param string $dealerLevel
     * @param string $district
     * @param string $region
     * @param string $regionLevel
     * @param string $serviceType
     * @param string $zone
     */
    public function __construct($dealerLevel = null, $district = null, $region = null, $regionLevel = null, $serviceType = null, $zone = null)
    {
        $this
            ->setDealerLevel($dealerLevel)
            ->setDistrict($district)
            ->setRegion($region)
            ->setRegionLevel($regionLevel)
            ->setServiceType($serviceType)
            ->setZone($zone);
    }
    /**
     * Get dealerLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerLevel()
    {
        return isset($this->dealerLevel) ? $this->dealerLevel : null;
    }
    /**
     * Set dealerLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerLevel
     * @return \Payktm\StructType\DealerServiceMaxQTYReq
     */
    public function setDealerLevel($dealerLevel = null)
    {
        // validation for constraint: string
        if (!is_null($dealerLevel) && !is_string($dealerLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerLevel)), __LINE__);
        }
        if (is_null($dealerLevel) || (is_array($dealerLevel) && empty($dealerLevel))) {
            unset($this->dealerLevel);
        } else {
            $this->dealerLevel = $dealerLevel;
        }
        return $this;
    }
    /**
     * Get district value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistrict()
    {
        return isset($this->district) ? $this->district : null;
    }
    /**
     * Set district value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $district
     * @return \Payktm\StructType\DealerServiceMaxQTYReq
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($district)), __LINE__);
        }
        if (is_null($district) || (is_array($district) && empty($district))) {
            unset($this->district);
        } else {
            $this->district = $district;
        }
        return $this;
    }
    /**
     * Get region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : null;
    }
    /**
     * Set region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $region
     * @return \Payktm\StructType\DealerServiceMaxQTYReq
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->region);
        } else {
            $this->region = $region;
        }
        return $this;
    }
    /**
     * Get regionLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegionLevel()
    {
        return isset($this->regionLevel) ? $this->regionLevel : null;
    }
    /**
     * Set regionLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regionLevel
     * @return \Payktm\StructType\DealerServiceMaxQTYReq
     */
    public function setRegionLevel($regionLevel = null)
    {
        // validation for constraint: string
        if (!is_null($regionLevel) && !is_string($regionLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionLevel)), __LINE__);
        }
        if (is_null($regionLevel) || (is_array($regionLevel) && empty($regionLevel))) {
            unset($this->regionLevel);
        } else {
            $this->regionLevel = $regionLevel;
        }
        return $this;
    }
    /**
     * Get serviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceType()
    {
        return isset($this->serviceType) ? $this->serviceType : null;
    }
    /**
     * Set serviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceType
     * @return \Payktm\StructType\DealerServiceMaxQTYReq
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->serviceType);
        } else {
            $this->serviceType = $serviceType;
        }
        return $this;
    }
    /**
     * Get zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZone()
    {
        return isset($this->zone) ? $this->zone : null;
    }
    /**
     * Set zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zone
     * @return \Payktm\StructType\DealerServiceMaxQTYReq
     */
    public function setZone($zone = null)
    {
        // validation for constraint: string
        if (!is_null($zone) && !is_string($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zone)), __LINE__);
        }
        if (is_null($zone) || (is_array($zone) && empty($zone))) {
            unset($this->zone);
        } else {
            $this->zone = $zone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerServiceMaxQTYReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
