<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerInfoQueryReq StructType
 * @subpackage Structs
 */
class DealerInfoQueryReq extends AbstractStructBase
{
    /**
     * The dealerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dealerId;
    /**
     * The dealerName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dealerName;
    /**
     * The mposHp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mposHp;
    /**
     * The parentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parentId;
    /**
     * Constructor method for DealerInfoQueryReq
     * @uses DealerInfoQueryReq::setDealerId()
     * @uses DealerInfoQueryReq::setDealerName()
     * @uses DealerInfoQueryReq::setMposHp()
     * @uses DealerInfoQueryReq::setParentId()
     * @param string $dealerId
     * @param string $dealerName
     * @param string $mposHp
     * @param string $parentId
     */
    public function __construct($dealerId = null, $dealerName = null, $mposHp = null, $parentId = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setDealerName($dealerName)
            ->setMposHp($mposHp)
            ->setParentId($parentId);
    }
    /**
     * Get dealerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerId()
    {
        return isset($this->dealerId) ? $this->dealerId : null;
    }
    /**
     * Set dealerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerId
     * @return \Payktm\StructType\DealerInfoQueryReq
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerId) && !is_string($dealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerId)), __LINE__);
        }
        if (is_null($dealerId) || (is_array($dealerId) && empty($dealerId))) {
            unset($this->dealerId);
        } else {
            $this->dealerId = $dealerId;
        }
        return $this;
    }
    /**
     * Get dealerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerName()
    {
        return isset($this->dealerName) ? $this->dealerName : null;
    }
    /**
     * Set dealerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerName
     * @return \Payktm\StructType\DealerInfoQueryReq
     */
    public function setDealerName($dealerName = null)
    {
        // validation for constraint: string
        if (!is_null($dealerName) && !is_string($dealerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerName)), __LINE__);
        }
        if (is_null($dealerName) || (is_array($dealerName) && empty($dealerName))) {
            unset($this->dealerName);
        } else {
            $this->dealerName = $dealerName;
        }
        return $this;
    }
    /**
     * Get mposHp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMposHp()
    {
        return isset($this->mposHp) ? $this->mposHp : null;
    }
    /**
     * Set mposHp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mposHp
     * @return \Payktm\StructType\DealerInfoQueryReq
     */
    public function setMposHp($mposHp = null)
    {
        // validation for constraint: string
        if (!is_null($mposHp) && !is_string($mposHp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mposHp)), __LINE__);
        }
        if (is_null($mposHp) || (is_array($mposHp) && empty($mposHp))) {
            unset($this->mposHp);
        } else {
            $this->mposHp = $mposHp;
        }
        return $this;
    }
    /**
     * Get parentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->parentId) ? $this->parentId : null;
    }
    /**
     * Set parentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \Payktm\StructType\DealerInfoQueryReq
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentId)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->parentId);
        } else {
            $this->parentId = $parentId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerInfoQueryReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
