<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerFileInfoSaveReq StructType
 * @subpackage Structs
 */
class DealerFileInfoSaveReq extends AbstractStructBase
{
    /**
     * The dealerFileInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerFileInfo[]
     */
    public $dealerFileInfo;
    /**
     * Constructor method for DealerFileInfoSaveReq
     * @uses DealerFileInfoSaveReq::setDealerFileInfo()
     * @param \Payktm\StructType\DealerFileInfo[] $dealerFileInfo
     */
    public function __construct(array $dealerFileInfo = array())
    {
        $this
            ->setDealerFileInfo($dealerFileInfo);
    }
    /**
     * Get dealerFileInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerFileInfo[]|null
     */
    public function getDealerFileInfo()
    {
        return isset($this->dealerFileInfo) ? $this->dealerFileInfo : null;
    }
    /**
     * Set dealerFileInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerFileInfo[] $dealerFileInfo
     * @return \Payktm\StructType\DealerFileInfoSaveReq
     */
    public function setDealerFileInfo(array $dealerFileInfo = array())
    {
        foreach ($dealerFileInfo as $dealerFileInfoSaveReqDealerFileInfoItem) {
            // validation for constraint: itemType
            if (!$dealerFileInfoSaveReqDealerFileInfoItem instanceof \Payktm\StructType\DealerFileInfo) {
                throw new \InvalidArgumentException(sprintf('The dealerFileInfo property can only contain items of \Payktm\StructType\DealerFileInfo, "%s" given', is_object($dealerFileInfoSaveReqDealerFileInfoItem) ? get_class($dealerFileInfoSaveReqDealerFileInfoItem) : gettype($dealerFileInfoSaveReqDealerFileInfoItem)), __LINE__);
            }
        }
        if (is_null($dealerFileInfo) || (is_array($dealerFileInfo) && empty($dealerFileInfo))) {
            unset($this->dealerFileInfo);
        } else {
            $this->dealerFileInfo = $dealerFileInfo;
        }
        return $this;
    }
    /**
     * Add item to dealerFileInfo value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerFileInfo $item
     * @return \Payktm\StructType\DealerFileInfoSaveReq
     */
    public function addToDealerFileInfo(\Payktm\StructType\DealerFileInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DealerFileInfo) {
            throw new \InvalidArgumentException(sprintf('The dealerFileInfo property can only contain items of \Payktm\StructType\DealerFileInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dealerFileInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerFileInfoSaveReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
