<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerFileInfoRsp StructType
 * @subpackage Structs
 */
class DealerFileInfoRsp extends AbstractStructBase
{
    /**
     * The dealerFileInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerFileInfo[]
     */
    public $dealerFileInfo;
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * Constructor method for DealerFileInfoRsp
     * @uses DealerFileInfoRsp::setDealerFileInfo()
     * @uses DealerFileInfoRsp::setRespCode()
     * @uses DealerFileInfoRsp::setRespDesc()
     * @param \Payktm\StructType\DealerFileInfo[] $dealerFileInfo
     * @param string $respCode
     * @param string $respDesc
     */
    public function __construct(array $dealerFileInfo = array(), $respCode = null, $respDesc = null)
    {
        $this
            ->setDealerFileInfo($dealerFileInfo)
            ->setRespCode($respCode)
            ->setRespDesc($respDesc);
    }
    /**
     * Get dealerFileInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerFileInfo[]|null
     */
    public function getDealerFileInfo()
    {
        return isset($this->dealerFileInfo) ? $this->dealerFileInfo : null;
    }
    /**
     * Set dealerFileInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerFileInfo[] $dealerFileInfo
     * @return \Payktm\StructType\DealerFileInfoRsp
     */
    public function setDealerFileInfo(array $dealerFileInfo = array())
    {
        foreach ($dealerFileInfo as $dealerFileInfoRspDealerFileInfoItem) {
            // validation for constraint: itemType
            if (!$dealerFileInfoRspDealerFileInfoItem instanceof \Payktm\StructType\DealerFileInfo) {
                throw new \InvalidArgumentException(sprintf('The dealerFileInfo property can only contain items of \Payktm\StructType\DealerFileInfo, "%s" given', is_object($dealerFileInfoRspDealerFileInfoItem) ? get_class($dealerFileInfoRspDealerFileInfoItem) : gettype($dealerFileInfoRspDealerFileInfoItem)), __LINE__);
            }
        }
        if (is_null($dealerFileInfo) || (is_array($dealerFileInfo) && empty($dealerFileInfo))) {
            unset($this->dealerFileInfo);
        } else {
            $this->dealerFileInfo = $dealerFileInfo;
        }
        return $this;
    }
    /**
     * Add item to dealerFileInfo value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerFileInfo $item
     * @return \Payktm\StructType\DealerFileInfoRsp
     */
    public function addToDealerFileInfo(\Payktm\StructType\DealerFileInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DealerFileInfo) {
            throw new \InvalidArgumentException(sprintf('The dealerFileInfo property can only contain items of \Payktm\StructType\DealerFileInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dealerFileInfo[] = $item;
        return $this;
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\DealerFileInfoRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\DealerFileInfoRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerFileInfoRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
