<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerApplySaveReq StructType
 * @subpackage Structs
 */
class DealerApplySaveReq extends AbstractStructBase
{
    /**
     * The attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\Attachment[]
     */
    public $attachment;
    /**
     * The contractInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\ContractInfo
     */
    public $contractInfo;
    /**
     * The dealerFileInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerFileInfo[]
     */
    public $dealerFileInfo;
    /**
     * The dealerInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerInfo
     */
    public $dealerInfo;
    /**
     * The dealerService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerService[]
     */
    public $dealerService;
    /**
     * The etopupConfig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\ETopupConfig
     */
    public $etopupConfig;
    /**
     * Constructor method for DealerApplySaveReq
     * @uses DealerApplySaveReq::setAttachment()
     * @uses DealerApplySaveReq::setContractInfo()
     * @uses DealerApplySaveReq::setDealerFileInfo()
     * @uses DealerApplySaveReq::setDealerInfo()
     * @uses DealerApplySaveReq::setDealerService()
     * @uses DealerApplySaveReq::setEtopupConfig()
     * @param \Payktm\StructType\Attachment[] $attachment
     * @param \Payktm\StructType\ContractInfo $contractInfo
     * @param \Payktm\StructType\DealerFileInfo[] $dealerFileInfo
     * @param \Payktm\StructType\DealerInfo $dealerInfo
     * @param \Payktm\StructType\DealerService[] $dealerService
     * @param \Payktm\StructType\ETopupConfig $etopupConfig
     */
    public function __construct(array $attachment = array(), \Payktm\StructType\ContractInfo $contractInfo = null, array $dealerFileInfo = array(), \Payktm\StructType\DealerInfo $dealerInfo = null, array $dealerService = array(), \Payktm\StructType\ETopupConfig $etopupConfig = null)
    {
        $this
            ->setAttachment($attachment)
            ->setContractInfo($contractInfo)
            ->setDealerFileInfo($dealerFileInfo)
            ->setDealerInfo($dealerInfo)
            ->setDealerService($dealerService)
            ->setEtopupConfig($etopupConfig);
    }
    /**
     * Get attachment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return isset($this->attachment) ? $this->attachment : null;
    }
    /**
     * Set attachment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\Attachment[] $attachment
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $dealerApplySaveReqAttachmentItem) {
            // validation for constraint: itemType
            if (!$dealerApplySaveReqAttachmentItem instanceof \Payktm\StructType\Attachment) {
                throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \Payktm\StructType\Attachment, "%s" given', is_object($dealerApplySaveReqAttachmentItem) ? get_class($dealerApplySaveReqAttachmentItem) : gettype($dealerApplySaveReqAttachmentItem)), __LINE__);
            }
        }
        if (is_null($attachment) || (is_array($attachment) && empty($attachment))) {
            unset($this->attachment);
        } else {
            $this->attachment = $attachment;
        }
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\Attachment $item
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function addToAttachment(\Payktm\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \Payktm\StructType\Attachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Get contractInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\ContractInfo|null
     */
    public function getContractInfo()
    {
        return isset($this->contractInfo) ? $this->contractInfo : null;
    }
    /**
     * Set contractInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\ContractInfo $contractInfo
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function setContractInfo(\Payktm\StructType\ContractInfo $contractInfo = null)
    {
        if (is_null($contractInfo) || (is_array($contractInfo) && empty($contractInfo))) {
            unset($this->contractInfo);
        } else {
            $this->contractInfo = $contractInfo;
        }
        return $this;
    }
    /**
     * Get dealerFileInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerFileInfo[]|null
     */
    public function getDealerFileInfo()
    {
        return isset($this->dealerFileInfo) ? $this->dealerFileInfo : null;
    }
    /**
     * Set dealerFileInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerFileInfo[] $dealerFileInfo
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function setDealerFileInfo(array $dealerFileInfo = array())
    {
        foreach ($dealerFileInfo as $dealerApplySaveReqDealerFileInfoItem) {
            // validation for constraint: itemType
            if (!$dealerApplySaveReqDealerFileInfoItem instanceof \Payktm\StructType\DealerFileInfo) {
                throw new \InvalidArgumentException(sprintf('The dealerFileInfo property can only contain items of \Payktm\StructType\DealerFileInfo, "%s" given', is_object($dealerApplySaveReqDealerFileInfoItem) ? get_class($dealerApplySaveReqDealerFileInfoItem) : gettype($dealerApplySaveReqDealerFileInfoItem)), __LINE__);
            }
        }
        if (is_null($dealerFileInfo) || (is_array($dealerFileInfo) && empty($dealerFileInfo))) {
            unset($this->dealerFileInfo);
        } else {
            $this->dealerFileInfo = $dealerFileInfo;
        }
        return $this;
    }
    /**
     * Add item to dealerFileInfo value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerFileInfo $item
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function addToDealerFileInfo(\Payktm\StructType\DealerFileInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DealerFileInfo) {
            throw new \InvalidArgumentException(sprintf('The dealerFileInfo property can only contain items of \Payktm\StructType\DealerFileInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dealerFileInfo[] = $item;
        return $this;
    }
    /**
     * Get dealerInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerInfo|null
     */
    public function getDealerInfo()
    {
        return isset($this->dealerInfo) ? $this->dealerInfo : null;
    }
    /**
     * Set dealerInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\DealerInfo $dealerInfo
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function setDealerInfo(\Payktm\StructType\DealerInfo $dealerInfo = null)
    {
        if (is_null($dealerInfo) || (is_array($dealerInfo) && empty($dealerInfo))) {
            unset($this->dealerInfo);
        } else {
            $this->dealerInfo = $dealerInfo;
        }
        return $this;
    }
    /**
     * Get dealerService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerService[]|null
     */
    public function getDealerService()
    {
        return isset($this->dealerService) ? $this->dealerService : null;
    }
    /**
     * Set dealerService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerService[] $dealerService
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function setDealerService(array $dealerService = array())
    {
        foreach ($dealerService as $dealerApplySaveReqDealerServiceItem) {
            // validation for constraint: itemType
            if (!$dealerApplySaveReqDealerServiceItem instanceof \Payktm\StructType\DealerService) {
                throw new \InvalidArgumentException(sprintf('The dealerService property can only contain items of \Payktm\StructType\DealerService, "%s" given', is_object($dealerApplySaveReqDealerServiceItem) ? get_class($dealerApplySaveReqDealerServiceItem) : gettype($dealerApplySaveReqDealerServiceItem)), __LINE__);
            }
        }
        if (is_null($dealerService) || (is_array($dealerService) && empty($dealerService))) {
            unset($this->dealerService);
        } else {
            $this->dealerService = $dealerService;
        }
        return $this;
    }
    /**
     * Add item to dealerService value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerService $item
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function addToDealerService(\Payktm\StructType\DealerService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DealerService) {
            throw new \InvalidArgumentException(sprintf('The dealerService property can only contain items of \Payktm\StructType\DealerService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dealerService[] = $item;
        return $this;
    }
    /**
     * Get etopupConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\ETopupConfig|null
     */
    public function getEtopupConfig()
    {
        return isset($this->etopupConfig) ? $this->etopupConfig : null;
    }
    /**
     * Set etopupConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\ETopupConfig $etopupConfig
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public function setEtopupConfig(\Payktm\StructType\ETopupConfig $etopupConfig = null)
    {
        if (is_null($etopupConfig) || (is_array($etopupConfig) && empty($etopupConfig))) {
            unset($this->etopupConfig);
        } else {
            $this->etopupConfig = $etopupConfig;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerApplySaveReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
