<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerAllInfoQueryRsp StructType
 * @subpackage Structs
 */
class DealerAllInfoQueryRsp extends AbstractStructBase
{
    /**
     * The attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\Attachment[]
     */
    public $attachment;
    /**
     * The contractInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\ContractInfo
     */
    public $contractInfo;
    /**
     * The dealerInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerInfo
     */
    public $dealerInfo;
    /**
     * The dealerService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerService[]
     */
    public $dealerService;
    /**
     * The etopupConfig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\ETopupConfig
     */
    public $etopupConfig;
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * Constructor method for DealerAllInfoQueryRsp
     * @uses DealerAllInfoQueryRsp::setAttachment()
     * @uses DealerAllInfoQueryRsp::setContractInfo()
     * @uses DealerAllInfoQueryRsp::setDealerInfo()
     * @uses DealerAllInfoQueryRsp::setDealerService()
     * @uses DealerAllInfoQueryRsp::setEtopupConfig()
     * @uses DealerAllInfoQueryRsp::setRespCode()
     * @uses DealerAllInfoQueryRsp::setRespDesc()
     * @param \Payktm\StructType\Attachment[] $attachment
     * @param \Payktm\StructType\ContractInfo $contractInfo
     * @param \Payktm\StructType\DealerInfo $dealerInfo
     * @param \Payktm\StructType\DealerService[] $dealerService
     * @param \Payktm\StructType\ETopupConfig $etopupConfig
     * @param string $respCode
     * @param string $respDesc
     */
    public function __construct(array $attachment = array(), \Payktm\StructType\ContractInfo $contractInfo = null, \Payktm\StructType\DealerInfo $dealerInfo = null, array $dealerService = array(), \Payktm\StructType\ETopupConfig $etopupConfig = null, $respCode = null, $respDesc = null)
    {
        $this
            ->setAttachment($attachment)
            ->setContractInfo($contractInfo)
            ->setDealerInfo($dealerInfo)
            ->setDealerService($dealerService)
            ->setEtopupConfig($etopupConfig)
            ->setRespCode($respCode)
            ->setRespDesc($respDesc);
    }
    /**
     * Get attachment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return isset($this->attachment) ? $this->attachment : null;
    }
    /**
     * Set attachment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\Attachment[] $attachment
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function setAttachment(array $attachment = array())
    {
        foreach ($attachment as $dealerAllInfoQueryRspAttachmentItem) {
            // validation for constraint: itemType
            if (!$dealerAllInfoQueryRspAttachmentItem instanceof \Payktm\StructType\Attachment) {
                throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \Payktm\StructType\Attachment, "%s" given', is_object($dealerAllInfoQueryRspAttachmentItem) ? get_class($dealerAllInfoQueryRspAttachmentItem) : gettype($dealerAllInfoQueryRspAttachmentItem)), __LINE__);
            }
        }
        if (is_null($attachment) || (is_array($attachment) && empty($attachment))) {
            unset($this->attachment);
        } else {
            $this->attachment = $attachment;
        }
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\Attachment $item
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function addToAttachment(\Payktm\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of \Payktm\StructType\Attachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Get contractInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\ContractInfo|null
     */
    public function getContractInfo()
    {
        return isset($this->contractInfo) ? $this->contractInfo : null;
    }
    /**
     * Set contractInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\ContractInfo $contractInfo
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function setContractInfo(\Payktm\StructType\ContractInfo $contractInfo = null)
    {
        if (is_null($contractInfo) || (is_array($contractInfo) && empty($contractInfo))) {
            unset($this->contractInfo);
        } else {
            $this->contractInfo = $contractInfo;
        }
        return $this;
    }
    /**
     * Get dealerInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerInfo|null
     */
    public function getDealerInfo()
    {
        return isset($this->dealerInfo) ? $this->dealerInfo : null;
    }
    /**
     * Set dealerInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\DealerInfo $dealerInfo
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function setDealerInfo(\Payktm\StructType\DealerInfo $dealerInfo = null)
    {
        if (is_null($dealerInfo) || (is_array($dealerInfo) && empty($dealerInfo))) {
            unset($this->dealerInfo);
        } else {
            $this->dealerInfo = $dealerInfo;
        }
        return $this;
    }
    /**
     * Get dealerService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerService[]|null
     */
    public function getDealerService()
    {
        return isset($this->dealerService) ? $this->dealerService : null;
    }
    /**
     * Set dealerService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerService[] $dealerService
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function setDealerService(array $dealerService = array())
    {
        foreach ($dealerService as $dealerAllInfoQueryRspDealerServiceItem) {
            // validation for constraint: itemType
            if (!$dealerAllInfoQueryRspDealerServiceItem instanceof \Payktm\StructType\DealerService) {
                throw new \InvalidArgumentException(sprintf('The dealerService property can only contain items of \Payktm\StructType\DealerService, "%s" given', is_object($dealerAllInfoQueryRspDealerServiceItem) ? get_class($dealerAllInfoQueryRspDealerServiceItem) : gettype($dealerAllInfoQueryRspDealerServiceItem)), __LINE__);
            }
        }
        if (is_null($dealerService) || (is_array($dealerService) && empty($dealerService))) {
            unset($this->dealerService);
        } else {
            $this->dealerService = $dealerService;
        }
        return $this;
    }
    /**
     * Add item to dealerService value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerService $item
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function addToDealerService(\Payktm\StructType\DealerService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DealerService) {
            throw new \InvalidArgumentException(sprintf('The dealerService property can only contain items of \Payktm\StructType\DealerService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dealerService[] = $item;
        return $this;
    }
    /**
     * Get etopupConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\ETopupConfig|null
     */
    public function getEtopupConfig()
    {
        return isset($this->etopupConfig) ? $this->etopupConfig : null;
    }
    /**
     * Set etopupConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\ETopupConfig $etopupConfig
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function setEtopupConfig(\Payktm\StructType\ETopupConfig $etopupConfig = null)
    {
        if (is_null($etopupConfig) || (is_array($etopupConfig) && empty($etopupConfig))) {
            unset($this->etopupConfig);
        } else {
            $this->etopupConfig = $etopupConfig;
        }
        return $this;
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerAllInfoQueryRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
