<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractInfo StructType
 * @subpackage Structs
 */
class ContractInfo extends AbstractStructBase
{
    /**
     * The contractId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contractId;
    /**
     * The contractName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contractName;
    /**
     * The createDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $createDate;
    /**
     * The dealerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dealerId;
    /**
     * The effectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $effectiveDate;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $expiryDate;
    /**
     * The notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $notes;
    /**
     * The opId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $opId;
    /**
     * The orgId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orgId;
    /**
     * Constructor method for ContractInfo
     * @uses ContractInfo::setContractId()
     * @uses ContractInfo::setContractName()
     * @uses ContractInfo::setCreateDate()
     * @uses ContractInfo::setDealerId()
     * @uses ContractInfo::setEffectiveDate()
     * @uses ContractInfo::setExpiryDate()
     * @uses ContractInfo::setNotes()
     * @uses ContractInfo::setOpId()
     * @uses ContractInfo::setOrgId()
     * @param string $contractId
     * @param string $contractName
     * @param string $createDate
     * @param string $dealerId
     * @param string $effectiveDate
     * @param string $expiryDate
     * @param string $notes
     * @param string $opId
     * @param string $orgId
     */
    public function __construct($contractId = null, $contractName = null, $createDate = null, $dealerId = null, $effectiveDate = null, $expiryDate = null, $notes = null, $opId = null, $orgId = null)
    {
        $this
            ->setContractId($contractId)
            ->setContractName($contractName)
            ->setCreateDate($createDate)
            ->setDealerId($dealerId)
            ->setEffectiveDate($effectiveDate)
            ->setExpiryDate($expiryDate)
            ->setNotes($notes)
            ->setOpId($opId)
            ->setOrgId($orgId);
    }
    /**
     * Get contractId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractId()
    {
        return isset($this->contractId) ? $this->contractId : null;
    }
    /**
     * Set contractId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractId
     * @return \Payktm\StructType\ContractInfo
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractId)), __LINE__);
        }
        if (is_null($contractId) || (is_array($contractId) && empty($contractId))) {
            unset($this->contractId);
        } else {
            $this->contractId = $contractId;
        }
        return $this;
    }
    /**
     * Get contractName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractName()
    {
        return isset($this->contractName) ? $this->contractName : null;
    }
    /**
     * Set contractName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractName
     * @return \Payktm\StructType\ContractInfo
     */
    public function setContractName($contractName = null)
    {
        // validation for constraint: string
        if (!is_null($contractName) && !is_string($contractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractName)), __LINE__);
        }
        if (is_null($contractName) || (is_array($contractName) && empty($contractName))) {
            unset($this->contractName);
        } else {
            $this->contractName = $contractName;
        }
        return $this;
    }
    /**
     * Get createDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateDate()
    {
        return isset($this->createDate) ? $this->createDate : null;
    }
    /**
     * Set createDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createDate
     * @return \Payktm\StructType\ContractInfo
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        if (is_null($createDate) || (is_array($createDate) && empty($createDate))) {
            unset($this->createDate);
        } else {
            $this->createDate = $createDate;
        }
        return $this;
    }
    /**
     * Get dealerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerId()
    {
        return isset($this->dealerId) ? $this->dealerId : null;
    }
    /**
     * Set dealerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerId
     * @return \Payktm\StructType\ContractInfo
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerId) && !is_string($dealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerId)), __LINE__);
        }
        if (is_null($dealerId) || (is_array($dealerId) && empty($dealerId))) {
            unset($this->dealerId);
        } else {
            $this->dealerId = $dealerId;
        }
        return $this;
    }
    /**
     * Get effectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return isset($this->effectiveDate) ? $this->effectiveDate : null;
    }
    /**
     * Set effectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveDate
     * @return \Payktm\StructType\ContractInfo
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->effectiveDate);
        } else {
            $this->effectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get expiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->expiryDate) ? $this->expiryDate : null;
    }
    /**
     * Set expiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \Payktm\StructType\ContractInfo
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->expiryDate);
        } else {
            $this->expiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->notes) ? $this->notes : null;
    }
    /**
     * Set notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \Payktm\StructType\ContractInfo
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->notes);
        } else {
            $this->notes = $notes;
        }
        return $this;
    }
    /**
     * Get opId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpId()
    {
        return isset($this->opId) ? $this->opId : null;
    }
    /**
     * Set opId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opId
     * @return \Payktm\StructType\ContractInfo
     */
    public function setOpId($opId = null)
    {
        // validation for constraint: string
        if (!is_null($opId) && !is_string($opId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opId)), __LINE__);
        }
        if (is_null($opId) || (is_array($opId) && empty($opId))) {
            unset($this->opId);
        } else {
            $this->opId = $opId;
        }
        return $this;
    }
    /**
     * Get orgId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgId()
    {
        return isset($this->orgId) ? $this->orgId : null;
    }
    /**
     * Set orgId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgId
     * @return \Payktm\StructType\ContractInfo
     */
    public function setOrgId($orgId = null)
    {
        // validation for constraint: string
        if (!is_null($orgId) && !is_string($orgId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgId)), __LINE__);
        }
        if (is_null($orgId) || (is_array($orgId) && empty($orgId))) {
            unset($this->orgId);
        } else {
            $this->orgId = $orgId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\ContractInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
