<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckDealerSalesReq StructType
 * @subpackage Structs
 */
class CheckDealerSalesReq extends AbstractStructBase
{
    /**
     * The billId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $billId;
    /**
     * The dealerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dealerId;
    /**
     * Constructor method for CheckDealerSalesReq
     * @uses CheckDealerSalesReq::setBillId()
     * @uses CheckDealerSalesReq::setDealerId()
     * @param string $billId
     * @param string $dealerId
     */
    public function __construct($billId = null, $dealerId = null)
    {
        $this
            ->setBillId($billId)
            ->setDealerId($dealerId);
    }
    /**
     * Get billId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillId()
    {
        return isset($this->billId) ? $this->billId : null;
    }
    /**
     * Set billId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billId
     * @return \Payktm\StructType\CheckDealerSalesReq
     */
    public function setBillId($billId = null)
    {
        // validation for constraint: string
        if (!is_null($billId) && !is_string($billId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billId)), __LINE__);
        }
        if (is_null($billId) || (is_array($billId) && empty($billId))) {
            unset($this->billId);
        } else {
            $this->billId = $billId;
        }
        return $this;
    }
    /**
     * Get dealerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerId()
    {
        return isset($this->dealerId) ? $this->dealerId : null;
    }
    /**
     * Set dealerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerId
     * @return \Payktm\StructType\CheckDealerSalesReq
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerId) && !is_string($dealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerId)), __LINE__);
        }
        if (is_null($dealerId) || (is_array($dealerId) && empty($dealerId))) {
            unset($this->dealerId);
        } else {
            $this->dealerId = $dealerId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\CheckDealerSalesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
