<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckDealerPasswordReq StructType
 * @subpackage Structs
 */
class CheckDealerPasswordReq extends AbstractStructBase
{
    /**
     * The mposNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mposNumber;
    /**
     * The tradePassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $tradePassword;
    /**
     * Constructor method for CheckDealerPasswordReq
     * @uses CheckDealerPasswordReq::setMposNumber()
     * @uses CheckDealerPasswordReq::setTradePassword()
     * @param string $mposNumber
     * @param string $tradePassword
     */
    public function __construct($mposNumber = null, $tradePassword = null)
    {
        $this
            ->setMposNumber($mposNumber)
            ->setTradePassword($tradePassword);
    }
    /**
     * Get mposNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMposNumber()
    {
        return isset($this->mposNumber) ? $this->mposNumber : null;
    }
    /**
     * Set mposNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mposNumber
     * @return \Payktm\StructType\CheckDealerPasswordReq
     */
    public function setMposNumber($mposNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mposNumber) && !is_string($mposNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mposNumber)), __LINE__);
        }
        if (is_null($mposNumber) || (is_array($mposNumber) && empty($mposNumber))) {
            unset($this->mposNumber);
        } else {
            $this->mposNumber = $mposNumber;
        }
        return $this;
    }
    /**
     * Get tradePassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTradePassword()
    {
        return isset($this->tradePassword) ? $this->tradePassword : null;
    }
    /**
     * Set tradePassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tradePassword
     * @return \Payktm\StructType\CheckDealerPasswordReq
     */
    public function setTradePassword($tradePassword = null)
    {
        // validation for constraint: string
        if (!is_null($tradePassword) && !is_string($tradePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tradePassword)), __LINE__);
        }
        if (is_null($tradePassword) || (is_array($tradePassword) && empty($tradePassword))) {
            unset($this->tradePassword);
        } else {
            $this->tradePassword = $tradePassword;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\CheckDealerPasswordReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
