<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BsStaticData StructType
 * @subpackage Structs
 */
class BsStaticData extends AbstractStructBase
{
    /**
     * The codeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeName;
    /**
     * The codeValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeValue;
    /**
     * Constructor method for BsStaticData
     * @uses BsStaticData::setCodeName()
     * @uses BsStaticData::setCodeValue()
     * @param string $codeName
     * @param string $codeValue
     */
    public function __construct($codeName = null, $codeValue = null)
    {
        $this
            ->setCodeName($codeName)
            ->setCodeValue($codeValue);
    }
    /**
     * Get codeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeName()
    {
        return isset($this->codeName) ? $this->codeName : null;
    }
    /**
     * Set codeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeName
     * @return \Payktm\StructType\BsStaticData
     */
    public function setCodeName($codeName = null)
    {
        // validation for constraint: string
        if (!is_null($codeName) && !is_string($codeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeName)), __LINE__);
        }
        if (is_null($codeName) || (is_array($codeName) && empty($codeName))) {
            unset($this->codeName);
        } else {
            $this->codeName = $codeName;
        }
        return $this;
    }
    /**
     * Get codeValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeValue()
    {
        return isset($this->codeValue) ? $this->codeValue : null;
    }
    /**
     * Set codeValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeValue
     * @return \Payktm\StructType\BsStaticData
     */
    public function setCodeValue($codeValue = null)
    {
        // validation for constraint: string
        if (!is_null($codeValue) && !is_string($codeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeValue)), __LINE__);
        }
        if (is_null($codeValue) || (is_array($codeValue) && empty($codeValue))) {
            unset($this->codeValue);
        } else {
            $this->codeValue = $codeValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\BsStaticData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
