<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BalanceInfoReq StructType
 * @subpackage Structs
 */
class BalanceInfoReq extends AbstractStructBase
{
    /**
     * The accountId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $accountId;
    /**
     * The dealerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dealerId;
    /**
     * The ext1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ext1;
    /**
     * The ext2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ext2;
    /**
     * The mposNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mposNumber;
    /**
     * Constructor method for BalanceInfoReq
     * @uses BalanceInfoReq::setAccountId()
     * @uses BalanceInfoReq::setDealerId()
     * @uses BalanceInfoReq::setExt1()
     * @uses BalanceInfoReq::setExt2()
     * @uses BalanceInfoReq::setMposNumber()
     * @param string $accountId
     * @param string $dealerId
     * @param string $ext1
     * @param string $ext2
     * @param string $mposNumber
     */
    public function __construct($accountId = null, $dealerId = null, $ext1 = null, $ext2 = null, $mposNumber = null)
    {
        $this
            ->setAccountId($accountId)
            ->setDealerId($dealerId)
            ->setExt1($ext1)
            ->setExt2($ext2)
            ->setMposNumber($mposNumber);
    }
    /**
     * Get accountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->accountId) ? $this->accountId : null;
    }
    /**
     * Set accountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \Payktm\StructType\BalanceInfoReq
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountId)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->accountId);
        } else {
            $this->accountId = $accountId;
        }
        return $this;
    }
    /**
     * Get dealerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerId()
    {
        return isset($this->dealerId) ? $this->dealerId : null;
    }
    /**
     * Set dealerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerId
     * @return \Payktm\StructType\BalanceInfoReq
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerId) && !is_string($dealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerId)), __LINE__);
        }
        if (is_null($dealerId) || (is_array($dealerId) && empty($dealerId))) {
            unset($this->dealerId);
        } else {
            $this->dealerId = $dealerId;
        }
        return $this;
    }
    /**
     * Get ext1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExt1()
    {
        return isset($this->ext1) ? $this->ext1 : null;
    }
    /**
     * Set ext1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ext1
     * @return \Payktm\StructType\BalanceInfoReq
     */
    public function setExt1($ext1 = null)
    {
        // validation for constraint: string
        if (!is_null($ext1) && !is_string($ext1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ext1)), __LINE__);
        }
        if (is_null($ext1) || (is_array($ext1) && empty($ext1))) {
            unset($this->ext1);
        } else {
            $this->ext1 = $ext1;
        }
        return $this;
    }
    /**
     * Get ext2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExt2()
    {
        return isset($this->ext2) ? $this->ext2 : null;
    }
    /**
     * Set ext2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ext2
     * @return \Payktm\StructType\BalanceInfoReq
     */
    public function setExt2($ext2 = null)
    {
        // validation for constraint: string
        if (!is_null($ext2) && !is_string($ext2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ext2)), __LINE__);
        }
        if (is_null($ext2) || (is_array($ext2) && empty($ext2))) {
            unset($this->ext2);
        } else {
            $this->ext2 = $ext2;
        }
        return $this;
    }
    /**
     * Get mposNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMposNumber()
    {
        return isset($this->mposNumber) ? $this->mposNumber : null;
    }
    /**
     * Set mposNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mposNumber
     * @return \Payktm\StructType\BalanceInfoReq
     */
    public function setMposNumber($mposNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mposNumber) && !is_string($mposNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mposNumber)), __LINE__);
        }
        if (is_null($mposNumber) || (is_array($mposNumber) && empty($mposNumber))) {
            unset($this->mposNumber);
        } else {
            $this->mposNumber = $mposNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\BalanceInfoReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
