<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Valid ServiceType
 * @subpackage Services
 */
class Valid extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named validDealerForBatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\ValidDealerForBatch $parameters
     * @return \Payktm\StructType\ValidDealerForBatchResponse|bool
     */
    public function validDealerForBatch(\Payktm\StructType\ValidDealerForBatch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->validDealerForBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\ValidDealerForBatchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
