<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Select ServiceType
 * @subpackage Services
 */
class Select extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named selectServiceQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\SelectServiceQuery $parameters
     * @return \Payktm\StructType\SelectServiceQueryResponse|bool
     */
    public function selectServiceQuery(\Payktm\StructType\SelectServiceQuery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->selectServiceQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\SelectServiceQueryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
