<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Docheck ServiceType
 * @subpackage Services
 */
class Docheck extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named do_checkDealer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\Do_checkDealer $parameters
     * @return \Payktm\StructType\Do_checkDealerResponse|bool
     */
    public function do_checkDealer(\Payktm\StructType\Do_checkDealer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->do_checkDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\Do_checkDealerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
