<?php

namespace Payktm\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Card ServiceType
 * @subpackage Services
 */
class Card extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cardRecall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Payktm\StructType\CardRecall $parameters
     * @return \Payktm\StructType\CardRecallResponse|bool
     */
    public function cardRecall(\Payktm\StructType\CardRecall $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cardRecall($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Payktm\StructType\CardRecallResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
