<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://tst.e-polis.kz/webservice/INSISPort?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://tst.e-polis.kz/webservice/INSISPort?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\Insis\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \App\Insis\ServiceType\Get($options);
/**
 * Sample call for getPolicy operation/method
 */
if ($get->getPolicy(new \App\Insis\StructType\GetPolicy()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDictionary operation/method
 */
if ($get->getDictionary(new \App\Insis\StructType\GetDictionary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClientClassByIIN operation/method
 */
if ($get->getClientClassByIIN(new \App\Insis\StructType\GetClientClassByIIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReport operation/method
 */
if ($get->getReport(new \App\Insis\StructType\GetReport()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCurrencyRate operation/method
 */
if ($get->getCurrencyRate(new \App\Insis\StructType\GetCurrencyRate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLimitConditions operation/method
 */
if ($get->getLimitConditions(new \App\Insis\StructType\GetLimitConditions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStaffByKeyFields operation/method
 */
if ($get->getStaffByKeyFields(new \App\Insis\StructType\GetStaffByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReportParams operation/method
 */
if ($get->getReportParams(new \App\Insis\StructType\GetReportParams()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAvailableReports operation/method
 */
if ($get->getAvailableReports(new \App\Insis\StructType\GetAvailableReports()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getObjectCarByKeyFields operation/method
 */
if ($get->getObjectCarByKeyFields(new \App\Insis\StructType\GetObjectCarByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCarViolations operation/method
 */
if ($get->getCarViolations(new \App\Insis\StructType\GetCarViolations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStandartRiskValues operation/method
 */
if ($get->getStandartRiskValues(new \App\Insis\StructType\GetStandartRiskValues()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAgentByKeyFields operation/method
 */
if ($get->getAgentByKeyFields(new \App\Insis\StructType\GetAgentByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStandartCovers operation/method
 */
if ($get->getStandartCovers(new \App\Insis\StructType\GetStandartCovers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTariffList operation/method
 */
if ($get->getTariffList(new \App\Insis\StructType\GetTariffList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBlanksNumbers operation/method
 */
if ($get->getBlanksNumbers(new \App\Insis\StructType\GetBlanksNumbers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBlankByKeyFields operation/method
 */
if ($get->getBlankByKeyFields(new \App\Insis\StructType\GetBlankByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBlankOrders operation/method
 */
if ($get->getBlankOrders(new \App\Insis\StructType\GetBlankOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBillByKeyFields operation/method
 */
if ($get->getBillByKeyFields(new \App\Insis\StructType\GetBillByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPoliciesForPaymentByKeyFields operation/method
 */
if ($get->getPoliciesForPaymentByKeyFields(new \App\Insis\StructType\GetPoliciesForPaymentByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCallList operation/method
 */
if ($get->getCallList(new \App\Insis\StructType\GetCallList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPolicyPaidPremium operation/method
 */
if ($get->getPolicyPaidPremium(new \App\Insis\StructType\GetPolicyPaidPremium()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBlankPrefixes operation/method
 */
if ($get->getBlankPrefixes(new \App\Insis\StructType\GetBlankPrefixes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPolicyApps operation/method
 */
if ($get->getPolicyApps(new \App\Insis\StructType\GetPolicyApps()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInsrTypeCoverInfo operation/method
 */
if ($get->getInsrTypeCoverInfo(new \App\Insis\StructType\GetInsrTypeCoverInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPoliciesByKeyFields operation/method
 */
if ($get->getPoliciesByKeyFields(new \App\Insis\StructType\GetPoliciesByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPolicyPrint operation/method
 */
if ($get->getPolicyPrint(new \App\Insis\StructType\GetPolicyPrint()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPrintForm operation/method
 */
if ($get->getPrintForm(new \App\Insis\StructType\GetPrintForm()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStandartCoverValues operation/method
 */
if ($get->getStandartCoverValues(new \App\Insis\StructType\GetStandartCoverValues()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStandartMultiCoverValues operation/method
 */
if ($get->getStandartMultiCoverValues(new \App\Insis\StructType\GetStandartMultiCoverValues()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSouvenirs operation/method
 */
if ($get->getSouvenirs(new \App\Insis\StructType\GetSouvenirs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getArchiveByKeyFields operation/method
 */
if ($get->getArchiveByKeyFields(new \App\Insis\StructType\GetArchiveByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getConfirmList operation/method
 */
if ($get->getConfirmList(new \App\Insis\StructType\GetConfirmList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClaimByPeriod operation/method
 */
if ($get->getClaimByPeriod(new \App\Insis\StructType\GetClaimByPeriod()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClaimByKeyFields operation/method
 */
if ($get->getClaimByKeyFields(new \App\Insis\StructType\GetClaimByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClaimSiteView operation/method
 */
if ($get->getClaimSiteView(new \App\Insis\StructType\GetClaimSiteView()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getObjectCargoByKeyFields operation/method
 */
if ($get->getObjectCargoByKeyFields(new \App\Insis\StructType\GetObjectCargoByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPeopleByKeyFields operation/method
 */
if ($get->getPeopleByKeyFields(new \App\Insis\StructType\GetPeopleByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClientClassByKeyFields operation/method
 */
if ($get->getClientClassByKeyFields(new \App\Insis\StructType\GetClientClassByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClientClassByManID operation/method
 */
if ($get->getClientClassByManID(new \App\Insis\StructType\GetClientClassByManID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPaymentInfo operation/method
 */
if ($get->getPaymentInfo(new \App\Insis\StructType\GetPaymentInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPolicyQRCode operation/method
 */
if ($get->getPolicyQRCode(new \App\Insis\StructType\GetPolicyQRCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDocumentAttachment operation/method
 */
if ($get->getDocumentAttachment(new \App\Insis\StructType\GetDocumentAttachment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoxByKeyFields operation/method
 */
if ($get->getBoxByKeyFields(new \App\Insis\StructType\GetBoxByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSiebelBoxPayment operation/method
 */
if ($get->getSiebelBoxPayment(new \App\Insis\StructType\GetSiebelBoxPayment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSiebelBox operation/method
 */
if ($get->getSiebelBox(new \App\Insis\StructType\GetSiebelBox()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoxIdByNumber operation/method
 */
if ($get->getBoxIdByNumber(new \App\Insis\StructType\GetBoxIdByNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoxStatus operation/method
 */
if ($get->getBoxStatus(new \App\Insis\StructType\GetBoxStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCarByNumber operation/method
 */
if ($get->getCarByNumber(new \App\Insis\StructType\GetCarByNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPremiumOGPOAuto operation/method
 */
if ($get->getPremiumOGPOAuto(new \App\Insis\StructType\GetPremiumOGPOAuto()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoxPayment operation/method
 */
if ($get->getBoxPayment(new \App\Insis\StructType\GetBoxPayment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClientClass operation/method
 */
if ($get->getClientClass(new \App\Insis\StructType\GetClientClass()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCarInfo operation/method
 */
if ($get->getCarInfo(new \App\Insis\StructType\GetCarInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVierifiedPeopleByKeyFields operation/method
 */
if ($get->getVierifiedPeopleByKeyFields(new \App\Insis\StructType\GetVierifiedPeopleByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPremiumOGPOAutoByIIN operation/method
 */
if ($get->getPremiumOGPOAutoByIIN(new \App\Insis\StructType\GetPremiumOGPOAutoByIIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPremiumTravelPolicy operation/method
 */
if ($get->getPremiumTravelPolicy(new \App\Insis\StructType\GetPremiumTravelPolicy()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoxes operation/method
 */
if ($get->getBoxes(new \App\Insis\StructType\GetBoxes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoxPremium operation/method
 */
if ($get->getBoxPremium(new \App\Insis\StructType\GetBoxPremium()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getArchivePolicyDetails operation/method
 */
if ($get->getArchivePolicyDetails(new \App\Insis\StructType\GetArchivePolicyDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGuidBank operation/method
 */
if ($get->getGuidBank(new \App\Insis\StructType\GetGuidBank()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBlanksNumbersByIIN operation/method
 */
if ($get->getBlanksNumbersByIIN(new \App\Insis\StructType\GetBlanksNumbersByIIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOnlinePolicies operation/method
 */
if ($get->getOnlinePolicies(new \App\Insis\StructType\GetOnlinePolicies()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPremiumAndInsName operation/method
 */
if ($get->getPremiumAndInsName(new \App\Insis\StructType\GetPremiumAndInsName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getObjectProperty operation/method
 */
if ($get->getObjectProperty(new \App\Insis\StructType\GetObjectProperty()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoxPremiumByIIN operation/method
 */
if ($get->getBoxPremiumByIIN(new \App\Insis\StructType\GetBoxPremiumByIIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPremForSite operation/method
 */
if ($get->getPremForSite(new \App\Insis\StructType\GetPremForSite()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVerifiedPeople operation/method
 */
if ($get->getVerifiedPeople(new \App\Insis\StructType\GetVerifiedPeople()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNameByIIN operation/method
 */
if ($get->getNameByIIN(new \App\Insis\StructType\GetNameByIIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMarkTS operation/method
 */
if ($get->getMarkTS(new \App\Insis\StructType\GetMarkTS()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPeopleShort operation/method
 */
if ($get->getPeopleShort(new \App\Insis\StructType\GetPeopleShort()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCarShort operation/method
 */
if ($get->getCarShort(new \App\Insis\StructType\GetCarShort()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOGPOFlagsByIIN operation/method
 */
if ($get->getOGPOFlagsByIIN(new \App\Insis\StructType\GetOGPOFlagsByIIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDraftRequest operation/method
 */
if ($get->getDraftRequest(new \App\Insis\StructType\GetDraftRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOnlineCover operation/method
 */
if ($get->getOnlineCover(new \App\Insis\StructType\GetOnlineCover()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOilByKeyFields operation/method
 */
if ($get->getOilByKeyFields(new \App\Insis\StructType\GetOilByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOilQR operation/method
 */
if ($get->getOilQR(new \App\Insis\StructType\GetOilQR()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRZNUByMan operation/method
 */
if ($get->getRZNUByMan(new \App\Insis\StructType\GetRZNUByMan()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDraftRequestForPrint operation/method
 */
if ($get->getDraftRequestForPrint(new \App\Insis\StructType\GetDraftRequestForPrint()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTechInspByKeyFields operation/method
 */
if ($get->getTechInspByKeyFields(new \App\Insis\StructType\GetTechInspByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPolicyIDbyRef operation/method
 */
if ($get->getPolicyIDbyRef(new \App\Insis\StructType\GetPolicyIDbyRef()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getHalykTravelByKeyFields operation/method
 */
if ($get->getHalykTravelByKeyFields(new \App\Insis\StructType\GetHalykTravelByKeyFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDopsByPolicyID operation/method
 */
if ($get->getDopsByPolicyID(new \App\Insis\StructType\GetDopsByPolicyID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \App\Insis\ServiceType\Set($options);
/**
 * Sample call for setPolicy operation/method
 */
if ($set->setPolicy(new \App\Insis\StructType\SetPolicy()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setApplication operation/method
 */
if ($set->setApplication(new \App\Insis\StructType\SetApplication()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setArchive operation/method
 */
if ($set->setArchive(new \App\Insis\StructType\SetArchive()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setCallCenterSale operation/method
 */
if ($set->setCallCenterSale(new \App\Insis\StructType\SetCallCenterSale()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setCash operation/method
 */
if ($set->setCash(new \App\Insis\StructType\SetCash()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPayment operation/method
 */
if ($set->setPayment(new \App\Insis\StructType\SetPayment()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setObjectCar operation/method
 */
if ($set->setObjectCar(new \App\Insis\StructType\SetObjectCar()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setBlanks operation/method
 */
if ($set->setBlanks(new \App\Insis\StructType\SetBlanks()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setAMEXPolicy operation/method
 */
if ($set->setAMEXPolicy(new \App\Insis\StructType\SetAMEXPolicy()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setOSRNSDetails operation/method
 */
if ($set->setOSRNSDetails(new \App\Insis\StructType\SetOSRNSDetails()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPolicyAttachment operation/method
 */
if ($set->setPolicyAttachment(new \App\Insis\StructType\SetPolicyAttachment()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setIncomingReinsurance operation/method
 */
if ($set->setIncomingReinsurance(new \App\Insis\StructType\SetIncomingReinsurance()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setArchiveConfirm operation/method
 */
if ($set->setArchiveConfirm(new \App\Insis\StructType\SetArchiveConfirm()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setObjectLiability operation/method
 */
if ($set->setObjectLiability(new \App\Insis\StructType\SetObjectLiability()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setObjectProperty operation/method
 */
if ($set->setObjectProperty(new \App\Insis\StructType\SetObjectProperty()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setObjectCargo operation/method
 */
if ($set->setObjectCargo(new \App\Insis\StructType\SetObjectCargo()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPeople operation/method
 */
if ($set->setPeople(new \App\Insis\StructType\SetPeople()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setSiebelHBCardInfo operation/method
 */
if ($set->setSiebelHBCardInfo(new \App\Insis\StructType\SetSiebelHBCardInfo()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setSiebelBoxPayment operation/method
 */
if ($set->setSiebelBoxPayment(new \App\Insis\StructType\SetSiebelBoxPayment()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setSiebelPolicy operation/method
 */
if ($set->setSiebelPolicy(new \App\Insis\StructType\SetSiebelPolicy()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setObjectCustom operation/method
 */
if ($set->setObjectCustom(new \App\Insis\StructType\SetObjectCustom()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setBoxAddress operation/method
 */
if ($set->setBoxAddress(new \App\Insis\StructType\SetBoxAddress()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setRequestData operation/method
 */
if ($set->setRequestData(new \App\Insis\StructType\SetRequestData()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setBoxPayment operation/method
 */
if ($set->setBoxPayment(new \App\Insis\StructType\SetBoxPayment()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setRequestDataFile operation/method
 */
if ($set->setRequestDataFile(new \App\Insis\StructType\SetRequestDataFile()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPolicyOGPOAuto operation/method
 */
if ($set->setPolicyOGPOAuto(new \App\Insis\StructType\SetPolicyOGPOAuto()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setBoxPayments operation/method
 */
if ($set->setBoxPayments(new \App\Insis\StructType\SetBoxPayments()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPaymentReference operation/method
 */
if ($set->setPaymentReference(new \App\Insis\StructType\SetPaymentReference()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setTravelPolicy operation/method
 */
if ($set->setTravelPolicy(new \App\Insis\StructType\SetTravelPolicy()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setVerifiedPeople operation/method
 */
if ($set->setVerifiedPeople(new \App\Insis\StructType\SetVerifiedPeople()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setObjectCarAttachment operation/method
 */
if ($set->setObjectCarAttachment(new \App\Insis\StructType\SetObjectCarAttachment()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setErrorText operation/method
 */
if ($set->setErrorText(new \App\Insis\StructType\SetErrorText()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPaymentSite operation/method
 */
if ($set->setPaymentSite(new \App\Insis\StructType\SetPaymentSite()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setBoxAddressKATO operation/method
 */
if ($set->setBoxAddressKATO(new \App\Insis\StructType\SetBoxAddressKATO()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setHalykTravel operation/method
 */
if ($set->setHalykTravel(new \App\Insis\StructType\SetHalykTravel()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setHalykTravelPayment operation/method
 */
if ($set->setHalykTravelPayment(new \App\Insis\StructType\SetHalykTravelPayment()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setClaimInfoAttach operation/method
 */
if ($set->setClaimInfoAttach(new \App\Insis\StructType\SetClaimInfoAttach()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Calc ServiceType
 */
$calc = new \App\Insis\ServiceType\Calc($options);
/**
 * Sample call for calcOsgpoAuto operation/method
 */
if ($calc->calcOsgpoAuto(new \App\Insis\StructType\CalcOsgpoAuto()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Sample call for calcOsgpoAutoCalendar operation/method
 */
if ($calc->calcOsgpoAutoCalendar(new \App\Insis\StructType\CalcOsgpoAutoCalendar()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Sample call for calcMst operation/method
 */
if ($calc->calcMst(new \App\Insis\StructType\CalcMst()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Sample call for calcOp_onai operation/method
 */
if ($calc->calcOp_onai(new \App\Insis\StructType\CalcOp_onai()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Sample call for calcCascoClassic operation/method
 */
if ($calc->calcCascoClassic(new \App\Insis\StructType\CalcCascoClassic()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Sample call for calcCascoAvangard operation/method
 */
if ($calc->calcCascoAvangard(new \App\Insis\StructType\CalcCascoAvangard()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Sample call for calcCascoEleganse operation/method
 */
if ($calc->calcCascoEleganse(new \App\Insis\StructType\CalcCascoEleganse()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \App\Insis\ServiceType\Check($options);
/**
 * Sample call for checkPolicyExistence operation/method
 */
if ($check->checkPolicyExistence(new \App\Insis\StructType\CheckPolicyExistence()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkObjectCar operation/method
 */
if ($check->checkObjectCar(new \App\Insis\StructType\CheckObjectCar()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkForClient operation/method
 */
if ($check->checkForClient(new \App\Insis\StructType\CheckForClient()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkPeopleInfo operation/method
 */
if ($check->checkPeopleInfo(new \App\Insis\StructType\CheckPeopleInfo()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkPeopleIIN operation/method
 */
if ($check->checkPeopleIIN(new \App\Insis\StructType\CheckPeopleIIN()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkSiebelBox operation/method
 */
if ($check->checkSiebelBox(new \App\Insis\StructType\CheckSiebelBox()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkFormats operation/method
 */
if ($check->checkFormats(new \App\Insis\StructType\CheckFormats()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkPKOState operation/method
 */
if ($check->checkPKOState(new \App\Insis\StructType\CheckPKOState()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkVerifiedStatus operation/method
 */
if ($check->checkVerifiedStatus(new \App\Insis\StructType\CheckVerifiedStatus()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkOnlineStatus operation/method
 */
if ($check->checkOnlineStatus(new \App\Insis\StructType\CheckOnlineStatus()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkPolicyStatus operation/method
 */
if ($check->checkPolicyStatus(new \App\Insis\StructType\CheckPolicyStatus()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Sey ServiceType
 */
$sey = new \App\Insis\ServiceType\Sey($options);
/**
 * Sample call for seyHello operation/method
 */
if ($sey->seyHello(new \App\Insis\StructType\SeyHello()) !== false) {
    print_r($sey->getResult());
} else {
    print_r($sey->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \App\Insis\ServiceType\Change($options);
/**
 * Sample call for changeBlankStatus operation/method
 */
if ($change->changeBlankStatus(new \App\Insis\StructType\ChangeBlankStatus()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \App\Insis\ServiceType\Create($options);
/**
 * Sample call for createBill operation/method
 */
if ($create->createBill(new \App\Insis\StructType\CreateBill()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createSiebelBox operation/method
 */
if ($create->createSiebelBox(new \App\Insis\StructType\CreateSiebelBox()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \App\Insis\ServiceType\Delete($options);
/**
 * Sample call for deleteBill operation/method
 */
if ($delete->deleteBill(new \App\Insis\StructType\DeleteBill()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteArchive operation/method
 */
if ($delete->deleteArchive(new \App\Insis\StructType\DeleteArchive()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteDocumentAttachment operation/method
 */
if ($delete->deleteDocumentAttachment(new \App\Insis\StructType\DeleteDocumentAttachment()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \App\Insis\ServiceType\Convert($options);
/**
 * Sample call for convertPolicy operation/method
 */
if ($convert->convertPolicy(new \App\Insis\StructType\ConvertPolicy()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Samples for Clean ServiceType
 */
$clean = new \App\Insis\ServiceType\Clean($options);
/**
 * Sample call for cleanQueue operation/method
 */
if ($clean->cleanQueue(new \App\Insis\StructType\CleanQueue()) !== false) {
    print_r($clean->getResult());
} else {
    print_r($clean->getLastError());
}
/**
 * Samples for Tie ServiceType
 */
$tie = new \App\Insis\ServiceType\Tie($options);
/**
 * Sample call for tieUp operation/method
 */
if ($tie->tieUp(new \App\Insis\StructType\TieUp()) !== false) {
    print_r($tie->getResult());
} else {
    print_r($tie->getLastError());
}
/**
 * Samples for Annul ServiceType
 */
$annul = new \App\Insis\ServiceType\Annul($options);
/**
 * Sample call for annulApplication operation/method
 */
if ($annul->annulApplication(new \App\Insis\StructType\AnnulApplication()) !== false) {
    print_r($annul->getResult());
} else {
    print_r($annul->getLastError());
}
/**
 * Sample call for annulBox operation/method
 */
if ($annul->annulBox(new \App\Insis\StructType\AnnulBox()) !== false) {
    print_r($annul->getResult());
} else {
    print_r($annul->getLastError());
}
/**
 * Sample call for annulOilCoupon operation/method
 */
if ($annul->annulOilCoupon(new \App\Insis\StructType\AnnulOilCoupon()) !== false) {
    print_r($annul->getResult());
} else {
    print_r($annul->getLastError());
}
/**
 * Sample call for annulTechInspection operation/method
 */
if ($annul->annulTechInspection(new \App\Insis\StructType\AnnulTechInspection()) !== false) {
    print_r($annul->getResult());
} else {
    print_r($annul->getLastError());
}
/**
 * Sample call for annulRecord operation/method
 */
if ($annul->annulRecord(new \App\Insis\StructType\AnnulRecord()) !== false) {
    print_r($annul->getResult());
} else {
    print_r($annul->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \App\Insis\ServiceType\Mark($options);
/**
 * Sample call for markPayment operation/method
 */
if ($mark->markPayment(new \App\Insis\StructType\MarkPayment()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markPaymentTerminal operation/method
 */
if ($mark->markPaymentTerminal(new \App\Insis\StructType\MarkPaymentTerminal()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Use ServiceType
 */
$use = new \App\Insis\ServiceType\_Use($options);
/**
 * Sample call for useDistribution operation/method
 */
if ($use->useDistribution(new \App\Insis\StructType\UseDistribution()) !== false) {
    print_r($use->getResult());
} else {
    print_r($use->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \App\Insis\ServiceType\Register($options);
/**
 * Sample call for registerBox operation/method
 */
if ($register->registerBox(new \App\Insis\StructType\RegisterBox()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Activate ServiceType
 */
$activate = new \App\Insis\ServiceType\Activate($options);
/**
 * Sample call for activateBox operation/method
 */
if ($activate->activateBox(new \App\Insis\StructType\ActivateBox()) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \App\Insis\ServiceType\Add($options);
/**
 * Sample call for addSiebelBoxFile operation/method
 */
if ($add->addSiebelBoxFile(new \App\Insis\StructType\AddSiebelBoxFile()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Merge ServiceType
 */
$merge = new \App\Insis\ServiceType\Merge($options);
/**
 * Sample call for mergeSiebelBoxClient operation/method
 */
if ($merge->mergeSiebelBoxClient(new \App\Insis\StructType\MergeSiebelBoxClient()) !== false) {
    print_r($merge->getResult());
} else {
    print_r($merge->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \App\Insis\ServiceType\Send($options);
/**
 * Sample call for sendPrintFormToEmail operation/method
 */
if ($send->sendPrintFormToEmail(new \App\Insis\StructType\SendPrintFormToEmail()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendTestMailForMe operation/method
 */
if ($send->sendTestMailForMe(new \App\Insis\StructType\SendTestMailForMe()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendSmsOil operation/method
 */
if ($send->sendSmsOil(new \App\Insis\StructType\SendSmsOil()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendSmsTechInspection operation/method
 */
if ($send->sendSmsTechInspection(new \App\Insis\StructType\SendSmsTechInspection()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendPrintFormToEmailIPTest operation/method
 */
if ($send->sendPrintFormToEmailIPTest(new \App\Insis\StructType\SendPrintFormToEmailIPTest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Prem ServiceType
 */
$prem = new \App\Insis\ServiceType\Prem($options);
/**
 * Sample call for PremFromFirstPolicy operation/method
 */
if ($prem->PremFromFirstPolicy(new \App\Insis\StructType\PremFromFirstPolicy()) !== false) {
    print_r($prem->getResult());
} else {
    print_r($prem->getLastError());
}
/**
 * Samples for APIT ServiceType
 */
$aPIT = new \App\Insis\ServiceType\APIT($options);
/**
 * Sample call for APITest operation/method
 */
if ($aPIT->APITest(new \App\Insis\StructType\APITest()) !== false) {
    print_r($aPIT->getResult());
} else {
    print_r($aPIT->getLastError());
}
/**
 * Samples for Renewal ServiceType
 */
$renewal = new \App\Insis\ServiceType\Renewal($options);
/**
 * Sample call for renewalPolicy operation/method
 */
if ($renewal->renewalPolicy(new \App\Insis\StructType\RenewalPolicy()) !== false) {
    print_r($renewal->getResult());
} else {
    print_r($renewal->getLastError());
}
/**
 * Samples for Active ServiceType
 */
$active = new \App\Insis\ServiceType\Active($options);
/**
 * Sample call for activeTechInspection operation/method
 */
if ($active->activeTechInspection(new \App\Insis\StructType\ActiveTechInspection()) !== false) {
    print_r($active->getResult());
} else {
    print_r($active->getLastError());
}
