<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for travelPolicy StructType
 * @subpackage Structs
 */
class TravelPolicy extends AbstractStructBase
{
    /**
     * The beginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginDate;
    /**
     * The clients
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\TravelClient[]
     */
    public $clients;
    /**
     * The countries
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $countries;
    /**
     * The coverType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coverType;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The insrType
     * @var int
     */
    public $insrType;
    /**
     * The insurCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insurCurrency;
    /**
     * The insurSum
     * @var int
     */
    public $insurSum;
    /**
     * The params
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $params;
    /**
     * Constructor method for travelPolicy
     * @uses TravelPolicy::setBeginDate()
     * @uses TravelPolicy::setClients()
     * @uses TravelPolicy::setCountries()
     * @uses TravelPolicy::setCoverType()
     * @uses TravelPolicy::setEndDate()
     * @uses TravelPolicy::setInsrType()
     * @uses TravelPolicy::setInsurCurrency()
     * @uses TravelPolicy::setInsurSum()
     * @uses TravelPolicy::setParams()
     * @param string $beginDate
     * @param \App\Insis\StructType\TravelClient[] $clients
     * @param string[] $countries
     * @param string $coverType
     * @param string $endDate
     * @param int $insrType
     * @param string $insurCurrency
     * @param int $insurSum
     * @param \App\Insis\StructType\ObjectParam[] $params
     */
    public function __construct($beginDate = null, array $clients = array(), array $countries = array(), $coverType = null, $endDate = null, $insrType = null, $insurCurrency = null, $insurSum = null, array $params = array())
    {
        $this
            ->setBeginDate($beginDate)
            ->setClients($clients)
            ->setCountries($countries)
            ->setCoverType($coverType)
            ->setEndDate($endDate)
            ->setInsrType($insrType)
            ->setInsurCurrency($insurCurrency)
            ->setInsurSum($insurSum)
            ->setParams($params);
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get clients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\TravelClient[]|null
     */
    public function getClients()
    {
        return isset($this->clients) ? $this->clients : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClients method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClients method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientsForArrayConstraintsFromSetClients(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelPolicyClientsItem) {
            // validation for constraint: itemType
            if (!$travelPolicyClientsItem instanceof \App\Insis\StructType\TravelClient) {
                $invalidValues[] = is_object($travelPolicyClientsItem) ? get_class($travelPolicyClientsItem) : sprintf('%s(%s)', gettype($travelPolicyClientsItem), var_export($travelPolicyClientsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The clients property can only contain items of type \App\Insis\StructType\TravelClient, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set clients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\TravelClient[] $clients
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setClients(array $clients = array())
    {
        // validation for constraint: array
        if ('' !== ($clientsArrayErrorMessage = self::validateClientsForArrayConstraintsFromSetClients($clients))) {
            throw new \InvalidArgumentException($clientsArrayErrorMessage, __LINE__);
        }
        if (is_null($clients) || (is_array($clients) && empty($clients))) {
            unset($this->clients);
        } else {
            $this->clients = $clients;
        }
        return $this;
    }
    /**
     * Add item to clients value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\TravelClient $item
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function addToClients(\App\Insis\StructType\TravelClient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\TravelClient) {
            throw new \InvalidArgumentException(sprintf('The clients property can only contain items of type \App\Insis\StructType\TravelClient, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->clients[] = $item;
        return $this;
    }
    /**
     * Get countries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCountries()
    {
        return isset($this->countries) ? $this->countries : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCountries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountries method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountriesForArrayConstraintsFromSetCountries(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelPolicyCountriesItem) {
            // validation for constraint: itemType
            if (!is_string($travelPolicyCountriesItem)) {
                $invalidValues[] = is_object($travelPolicyCountriesItem) ? get_class($travelPolicyCountriesItem) : sprintf('%s(%s)', gettype($travelPolicyCountriesItem), var_export($travelPolicyCountriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The countries property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set countries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $countries
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setCountries(array $countries = array())
    {
        // validation for constraint: array
        if ('' !== ($countriesArrayErrorMessage = self::validateCountriesForArrayConstraintsFromSetCountries($countries))) {
            throw new \InvalidArgumentException($countriesArrayErrorMessage, __LINE__);
        }
        if (is_null($countries) || (is_array($countries) && empty($countries))) {
            unset($this->countries);
        } else {
            $this->countries = $countries;
        }
        return $this;
    }
    /**
     * Add item to countries value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function addToCountries($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The countries property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->countries[] = $item;
        return $this;
    }
    /**
     * Get coverType value
     * @return string|null
     */
    public function getCoverType()
    {
        return $this->coverType;
    }
    /**
     * Set coverType value
     * @param string $coverType
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setCoverType($coverType = null)
    {
        // validation for constraint: string
        if (!is_null($coverType) && !is_string($coverType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverType, true), gettype($coverType)), __LINE__);
        }
        $this->coverType = $coverType;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get insrType value
     * @return int|null
     */
    public function getInsrType()
    {
        return $this->insrType;
    }
    /**
     * Set insrType value
     * @param int $insrType
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setInsrType($insrType = null)
    {
        // validation for constraint: int
        if (!is_null($insrType) && !(is_int($insrType) || ctype_digit($insrType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insrType, true), gettype($insrType)), __LINE__);
        }
        $this->insrType = $insrType;
        return $this;
    }
    /**
     * Get insurCurrency value
     * @return string|null
     */
    public function getInsurCurrency()
    {
        return $this->insurCurrency;
    }
    /**
     * Set insurCurrency value
     * @param string $insurCurrency
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setInsurCurrency($insurCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($insurCurrency) && !is_string($insurCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insurCurrency, true), gettype($insurCurrency)), __LINE__);
        }
        $this->insurCurrency = $insurCurrency;
        return $this;
    }
    /**
     * Get insurSum value
     * @return int|null
     */
    public function getInsurSum()
    {
        return $this->insurSum;
    }
    /**
     * Set insurSum value
     * @param int $insurSum
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setInsurSum($insurSum = null)
    {
        // validation for constraint: int
        if (!is_null($insurSum) && !(is_int($insurSum) || ctype_digit($insurSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insurSum, true), gettype($insurSum)), __LINE__);
        }
        $this->insurSum = $insurSum;
        return $this;
    }
    /**
     * Get params value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getParams()
    {
        return isset($this->params) ? $this->params : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParamsForArrayConstraintsFromSetParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelPolicyParamsItem) {
            // validation for constraint: itemType
            if (!$travelPolicyParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($travelPolicyParamsItem) ? get_class($travelPolicyParamsItem) : sprintf('%s(%s)', gettype($travelPolicyParamsItem), var_export($travelPolicyParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The params property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set params value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $params
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function setParams(array $params = array())
    {
        // validation for constraint: array
        if ('' !== ($paramsArrayErrorMessage = self::validateParamsForArrayConstraintsFromSetParams($params))) {
            throw new \InvalidArgumentException($paramsArrayErrorMessage, __LINE__);
        }
        if (is_null($params) || (is_array($params) && empty($params))) {
            unset($this->params);
        } else {
            $this->params = $params;
        }
        return $this;
    }
    /**
     * Add item to params value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\TravelPolicy
     */
    public function addToParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The params property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->params[] = $item;
        return $this;
    }
}
