<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for siebelBeneficiary StructType
 * @subpackage Structs
 */
class SiebelBeneficiary extends AbstractStructBase
{
    /**
     * The accountFlg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountFlg;
    /**
     * The accountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountName;
    /**
     * The BIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BIN;
    /**
     * The beneficiaryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelBeneficiaryAddress[]
     */
    public $beneficiaryAddress;
    /**
     * The beneficiaryBank
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\SiebelBeneficiaryBank[]
     */
    public $beneficiaryBank;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The IIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IIN;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The residence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $residence;
    /**
     * The sector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sector;
    /**
     * Constructor method for siebelBeneficiary
     * @uses SiebelBeneficiary::setAccountFlg()
     * @uses SiebelBeneficiary::setAccountName()
     * @uses SiebelBeneficiary::setBIN()
     * @uses SiebelBeneficiary::setBeneficiaryAddress()
     * @uses SiebelBeneficiary::setBeneficiaryBank()
     * @uses SiebelBeneficiary::setBirthDate()
     * @uses SiebelBeneficiary::setCountry()
     * @uses SiebelBeneficiary::setIIN()
     * @uses SiebelBeneficiary::setLastName()
     * @uses SiebelBeneficiary::setName()
     * @uses SiebelBeneficiary::setResidence()
     * @uses SiebelBeneficiary::setSector()
     * @param string $accountFlg
     * @param string $accountName
     * @param string $bIN
     * @param \App\Insis\StructType\SiebelBeneficiaryAddress[] $beneficiaryAddress
     * @param \App\Insis\StructType\SiebelBeneficiaryBank[] $beneficiaryBank
     * @param string $birthDate
     * @param string $country
     * @param string $iIN
     * @param string $lastName
     * @param string $name
     * @param string $residence
     * @param string $sector
     */
    public function __construct($accountFlg = null, $accountName = null, $bIN = null, array $beneficiaryAddress = array(), array $beneficiaryBank = array(), $birthDate = null, $country = null, $iIN = null, $lastName = null, $name = null, $residence = null, $sector = null)
    {
        $this
            ->setAccountFlg($accountFlg)
            ->setAccountName($accountName)
            ->setBIN($bIN)
            ->setBeneficiaryAddress($beneficiaryAddress)
            ->setBeneficiaryBank($beneficiaryBank)
            ->setBirthDate($birthDate)
            ->setCountry($country)
            ->setIIN($iIN)
            ->setLastName($lastName)
            ->setName($name)
            ->setResidence($residence)
            ->setSector($sector);
    }
    /**
     * Get accountFlg value
     * @return string|null
     */
    public function getAccountFlg()
    {
        return $this->accountFlg;
    }
    /**
     * Set accountFlg value
     * @param string $accountFlg
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setAccountFlg($accountFlg = null)
    {
        // validation for constraint: string
        if (!is_null($accountFlg) && !is_string($accountFlg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountFlg, true), gettype($accountFlg)), __LINE__);
        }
        $this->accountFlg = $accountFlg;
        return $this;
    }
    /**
     * Get accountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->accountName;
    }
    /**
     * Set accountName value
     * @param string $accountName
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->accountName = $accountName;
        return $this;
    }
    /**
     * Get BIN value
     * @return string|null
     */
    public function getBIN()
    {
        return $this->BIN;
    }
    /**
     * Set BIN value
     * @param string $bIN
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setBIN($bIN = null)
    {
        // validation for constraint: string
        if (!is_null($bIN) && !is_string($bIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIN, true), gettype($bIN)), __LINE__);
        }
        $this->BIN = $bIN;
        return $this;
    }
    /**
     * Get beneficiaryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelBeneficiaryAddress[]|null
     */
    public function getBeneficiaryAddress()
    {
        return isset($this->beneficiaryAddress) ? $this->beneficiaryAddress : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBeneficiaryAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeneficiaryAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeneficiaryAddressForArrayConstraintsFromSetBeneficiaryAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelBeneficiaryBeneficiaryAddressItem) {
            // validation for constraint: itemType
            if (!$siebelBeneficiaryBeneficiaryAddressItem instanceof \App\Insis\StructType\SiebelBeneficiaryAddress) {
                $invalidValues[] = is_object($siebelBeneficiaryBeneficiaryAddressItem) ? get_class($siebelBeneficiaryBeneficiaryAddressItem) : sprintf('%s(%s)', gettype($siebelBeneficiaryBeneficiaryAddressItem), var_export($siebelBeneficiaryBeneficiaryAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beneficiaryAddress property can only contain items of type \App\Insis\StructType\SiebelBeneficiaryAddress, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beneficiaryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelBeneficiaryAddress[] $beneficiaryAddress
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setBeneficiaryAddress(array $beneficiaryAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($beneficiaryAddressArrayErrorMessage = self::validateBeneficiaryAddressForArrayConstraintsFromSetBeneficiaryAddress($beneficiaryAddress))) {
            throw new \InvalidArgumentException($beneficiaryAddressArrayErrorMessage, __LINE__);
        }
        if (is_null($beneficiaryAddress) || (is_array($beneficiaryAddress) && empty($beneficiaryAddress))) {
            unset($this->beneficiaryAddress);
        } else {
            $this->beneficiaryAddress = $beneficiaryAddress;
        }
        return $this;
    }
    /**
     * Add item to beneficiaryAddress value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelBeneficiaryAddress $item
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function addToBeneficiaryAddress(\App\Insis\StructType\SiebelBeneficiaryAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelBeneficiaryAddress) {
            throw new \InvalidArgumentException(sprintf('The beneficiaryAddress property can only contain items of type \App\Insis\StructType\SiebelBeneficiaryAddress, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beneficiaryAddress[] = $item;
        return $this;
    }
    /**
     * Get beneficiaryBank value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\SiebelBeneficiaryBank[]|null
     */
    public function getBeneficiaryBank()
    {
        return isset($this->beneficiaryBank) ? $this->beneficiaryBank : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBeneficiaryBank method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeneficiaryBank method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeneficiaryBankForArrayConstraintsFromSetBeneficiaryBank(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siebelBeneficiaryBeneficiaryBankItem) {
            // validation for constraint: itemType
            if (!$siebelBeneficiaryBeneficiaryBankItem instanceof \App\Insis\StructType\SiebelBeneficiaryBank) {
                $invalidValues[] = is_object($siebelBeneficiaryBeneficiaryBankItem) ? get_class($siebelBeneficiaryBeneficiaryBankItem) : sprintf('%s(%s)', gettype($siebelBeneficiaryBeneficiaryBankItem), var_export($siebelBeneficiaryBeneficiaryBankItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beneficiaryBank property can only contain items of type \App\Insis\StructType\SiebelBeneficiaryBank, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beneficiaryBank value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelBeneficiaryBank[] $beneficiaryBank
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setBeneficiaryBank(array $beneficiaryBank = array())
    {
        // validation for constraint: array
        if ('' !== ($beneficiaryBankArrayErrorMessage = self::validateBeneficiaryBankForArrayConstraintsFromSetBeneficiaryBank($beneficiaryBank))) {
            throw new \InvalidArgumentException($beneficiaryBankArrayErrorMessage, __LINE__);
        }
        if (is_null($beneficiaryBank) || (is_array($beneficiaryBank) && empty($beneficiaryBank))) {
            unset($this->beneficiaryBank);
        } else {
            $this->beneficiaryBank = $beneficiaryBank;
        }
        return $this;
    }
    /**
     * Add item to beneficiaryBank value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\SiebelBeneficiaryBank $item
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function addToBeneficiaryBank(\App\Insis\StructType\SiebelBeneficiaryBank $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\SiebelBeneficiaryBank) {
            throw new \InvalidArgumentException(sprintf('The beneficiaryBank property can only contain items of type \App\Insis\StructType\SiebelBeneficiaryBank, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beneficiaryBank[] = $item;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get IIN value
     * @return string|null
     */
    public function getIIN()
    {
        return $this->IIN;
    }
    /**
     * Set IIN value
     * @param string $iIN
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setIIN($iIN = null)
    {
        // validation for constraint: string
        if (!is_null($iIN) && !is_string($iIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iIN, true), gettype($iIN)), __LINE__);
        }
        $this->IIN = $iIN;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get residence value
     * @return string|null
     */
    public function getResidence()
    {
        return $this->residence;
    }
    /**
     * Set residence value
     * @param string $residence
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setResidence($residence = null)
    {
        // validation for constraint: string
        if (!is_null($residence) && !is_string($residence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residence, true), gettype($residence)), __LINE__);
        }
        $this->residence = $residence;
        return $this;
    }
    /**
     * Get sector value
     * @return string|null
     */
    public function getSector()
    {
        return $this->sector;
    }
    /**
     * Set sector value
     * @param string $sector
     * @return \App\Insis\StructType\SiebelBeneficiary
     */
    public function setSector($sector = null)
    {
        // validation for constraint: string
        if (!is_null($sector) && !is_string($sector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sector, true), gettype($sector)), __LINE__);
        }
        $this->sector = $sector;
        return $this;
    }
}
