<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setPolicyAttachment StructType
 * Meta information extracted from the WSDL
 * - type: tns:setPolicyAttachment
 * @subpackage Structs
 */
class SetPolicyAttachment extends AbstractStructBase
{
    /**
     * The aPolicyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aPolicyID;
    /**
     * The aPolicyAttachments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\Attachment[]
     */
    public $aPolicyAttachments;
    /**
     * Constructor method for setPolicyAttachment
     * @uses SetPolicyAttachment::setAPolicyID()
     * @uses SetPolicyAttachment::setAPolicyAttachments()
     * @param int $aPolicyID
     * @param \App\Insis\StructType\Attachment[] $aPolicyAttachments
     */
    public function __construct($aPolicyID = null, array $aPolicyAttachments = array())
    {
        $this
            ->setAPolicyID($aPolicyID)
            ->setAPolicyAttachments($aPolicyAttachments);
    }
    /**
     * Get aPolicyID value
     * @return int|null
     */
    public function getAPolicyID()
    {
        return $this->aPolicyID;
    }
    /**
     * Set aPolicyID value
     * @param int $aPolicyID
     * @return \App\Insis\StructType\SetPolicyAttachment
     */
    public function setAPolicyID($aPolicyID = null)
    {
        // validation for constraint: int
        if (!is_null($aPolicyID) && !(is_int($aPolicyID) || ctype_digit($aPolicyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aPolicyID, true), gettype($aPolicyID)), __LINE__);
        }
        $this->aPolicyID = $aPolicyID;
        return $this;
    }
    /**
     * Get aPolicyAttachments value
     * @return \App\Insis\StructType\Attachment[]|null
     */
    public function getAPolicyAttachments()
    {
        return $this->aPolicyAttachments;
    }
    /**
     * This method is responsible for validating the values passed to the setAPolicyAttachments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAPolicyAttachments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAPolicyAttachmentsForArrayConstraintsFromSetAPolicyAttachments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $setPolicyAttachmentAPolicyAttachmentsItem) {
            // validation for constraint: itemType
            if (!$setPolicyAttachmentAPolicyAttachmentsItem instanceof \App\Insis\StructType\Attachment) {
                $invalidValues[] = is_object($setPolicyAttachmentAPolicyAttachmentsItem) ? get_class($setPolicyAttachmentAPolicyAttachmentsItem) : sprintf('%s(%s)', gettype($setPolicyAttachmentAPolicyAttachmentsItem), var_export($setPolicyAttachmentAPolicyAttachmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aPolicyAttachments property can only contain items of type \App\Insis\StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aPolicyAttachments value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Attachment[] $aPolicyAttachments
     * @return \App\Insis\StructType\SetPolicyAttachment
     */
    public function setAPolicyAttachments(array $aPolicyAttachments = array())
    {
        // validation for constraint: array
        if ('' !== ($aPolicyAttachmentsArrayErrorMessage = self::validateAPolicyAttachmentsForArrayConstraintsFromSetAPolicyAttachments($aPolicyAttachments))) {
            throw new \InvalidArgumentException($aPolicyAttachmentsArrayErrorMessage, __LINE__);
        }
        $this->aPolicyAttachments = $aPolicyAttachments;
        return $this;
    }
    /**
     * Add item to aPolicyAttachments value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Attachment $item
     * @return \App\Insis\StructType\SetPolicyAttachment
     */
    public function addToAPolicyAttachments(\App\Insis\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The aPolicyAttachments property can only contain items of type \App\Insis\StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aPolicyAttachments[] = $item;
        return $this;
    }
}
