<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setOSRNSDetails StructType
 * Meta information extracted from the WSDL
 * - type: tns:setOSRNSDetails
 * @subpackage Structs
 */
class SetOSRNSDetails extends AbstractStructBase
{
    /**
     * The aBorderoNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aBorderoNo;
    /**
     * The aPolicyNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aPolicyNo;
    /**
     * The aAnnexId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aAnnexId;
    /**
     * The aTrancheNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aTrancheNo;
    /**
     * Constructor method for setOSRNSDetails
     * @uses SetOSRNSDetails::setABorderoNo()
     * @uses SetOSRNSDetails::setAPolicyNo()
     * @uses SetOSRNSDetails::setAAnnexId()
     * @uses SetOSRNSDetails::setATrancheNo()
     * @param string $aBorderoNo
     * @param string $aPolicyNo
     * @param int $aAnnexId
     * @param int $aTrancheNo
     */
    public function __construct($aBorderoNo = null, $aPolicyNo = null, $aAnnexId = null, $aTrancheNo = null)
    {
        $this
            ->setABorderoNo($aBorderoNo)
            ->setAPolicyNo($aPolicyNo)
            ->setAAnnexId($aAnnexId)
            ->setATrancheNo($aTrancheNo);
    }
    /**
     * Get aBorderoNo value
     * @return string|null
     */
    public function getABorderoNo()
    {
        return $this->aBorderoNo;
    }
    /**
     * Set aBorderoNo value
     * @param string $aBorderoNo
     * @return \App\Insis\StructType\SetOSRNSDetails
     */
    public function setABorderoNo($aBorderoNo = null)
    {
        // validation for constraint: string
        if (!is_null($aBorderoNo) && !is_string($aBorderoNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBorderoNo, true), gettype($aBorderoNo)), __LINE__);
        }
        $this->aBorderoNo = $aBorderoNo;
        return $this;
    }
    /**
     * Get aPolicyNo value
     * @return string|null
     */
    public function getAPolicyNo()
    {
        return $this->aPolicyNo;
    }
    /**
     * Set aPolicyNo value
     * @param string $aPolicyNo
     * @return \App\Insis\StructType\SetOSRNSDetails
     */
    public function setAPolicyNo($aPolicyNo = null)
    {
        // validation for constraint: string
        if (!is_null($aPolicyNo) && !is_string($aPolicyNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPolicyNo, true), gettype($aPolicyNo)), __LINE__);
        }
        $this->aPolicyNo = $aPolicyNo;
        return $this;
    }
    /**
     * Get aAnnexId value
     * @return int|null
     */
    public function getAAnnexId()
    {
        return $this->aAnnexId;
    }
    /**
     * Set aAnnexId value
     * @param int $aAnnexId
     * @return \App\Insis\StructType\SetOSRNSDetails
     */
    public function setAAnnexId($aAnnexId = null)
    {
        // validation for constraint: int
        if (!is_null($aAnnexId) && !(is_int($aAnnexId) || ctype_digit($aAnnexId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aAnnexId, true), gettype($aAnnexId)), __LINE__);
        }
        $this->aAnnexId = $aAnnexId;
        return $this;
    }
    /**
     * Get aTrancheNo value
     * @return int|null
     */
    public function getATrancheNo()
    {
        return $this->aTrancheNo;
    }
    /**
     * Set aTrancheNo value
     * @param int $aTrancheNo
     * @return \App\Insis\StructType\SetOSRNSDetails
     */
    public function setATrancheNo($aTrancheNo = null)
    {
        // validation for constraint: int
        if (!is_null($aTrancheNo) && !(is_int($aTrancheNo) || ctype_digit($aTrancheNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aTrancheNo, true), gettype($aTrancheNo)), __LINE__);
        }
        $this->aTrancheNo = $aTrancheNo;
        return $this;
    }
}
