<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setApplication StructType
 * Meta information extracted from the WSDL
 * - type: tns:setApplication
 * @subpackage Structs
 */
class SetApplication extends AbstractStructBase
{
    /**
     * The aPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\Policy
     */
    public $aPolicy;
    /**
     * The aPeopleArr
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\People[]
     */
    public $aPeopleArr;
    /**
     * The aObjectCarArr
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectCar[]
     */
    public $aObjectCarArr;
    /**
     * Constructor method for setApplication
     * @uses SetApplication::setAPolicy()
     * @uses SetApplication::setAPeopleArr()
     * @uses SetApplication::setAObjectCarArr()
     * @param \App\Insis\StructType\Policy $aPolicy
     * @param \App\Insis\StructType\People[] $aPeopleArr
     * @param \App\Insis\StructType\ObjectCar[] $aObjectCarArr
     */
    public function __construct(\App\Insis\StructType\Policy $aPolicy = null, array $aPeopleArr = array(), array $aObjectCarArr = array())
    {
        $this
            ->setAPolicy($aPolicy)
            ->setAPeopleArr($aPeopleArr)
            ->setAObjectCarArr($aObjectCarArr);
    }
    /**
     * Get aPolicy value
     * @return \App\Insis\StructType\Policy|null
     */
    public function getAPolicy()
    {
        return $this->aPolicy;
    }
    /**
     * Set aPolicy value
     * @param \App\Insis\StructType\Policy $aPolicy
     * @return \App\Insis\StructType\SetApplication
     */
    public function setAPolicy(\App\Insis\StructType\Policy $aPolicy = null)
    {
        $this->aPolicy = $aPolicy;
        return $this;
    }
    /**
     * Get aPeopleArr value
     * @return \App\Insis\StructType\People[]|null
     */
    public function getAPeopleArr()
    {
        return $this->aPeopleArr;
    }
    /**
     * This method is responsible for validating the values passed to the setAPeopleArr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAPeopleArr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAPeopleArrForArrayConstraintsFromSetAPeopleArr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $setApplicationAPeopleArrItem) {
            // validation for constraint: itemType
            if (!$setApplicationAPeopleArrItem instanceof \App\Insis\StructType\People) {
                $invalidValues[] = is_object($setApplicationAPeopleArrItem) ? get_class($setApplicationAPeopleArrItem) : sprintf('%s(%s)', gettype($setApplicationAPeopleArrItem), var_export($setApplicationAPeopleArrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aPeopleArr property can only contain items of type \App\Insis\StructType\People, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aPeopleArr value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\People[] $aPeopleArr
     * @return \App\Insis\StructType\SetApplication
     */
    public function setAPeopleArr(array $aPeopleArr = array())
    {
        // validation for constraint: array
        if ('' !== ($aPeopleArrArrayErrorMessage = self::validateAPeopleArrForArrayConstraintsFromSetAPeopleArr($aPeopleArr))) {
            throw new \InvalidArgumentException($aPeopleArrArrayErrorMessage, __LINE__);
        }
        $this->aPeopleArr = $aPeopleArr;
        return $this;
    }
    /**
     * Add item to aPeopleArr value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\People $item
     * @return \App\Insis\StructType\SetApplication
     */
    public function addToAPeopleArr(\App\Insis\StructType\People $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\People) {
            throw new \InvalidArgumentException(sprintf('The aPeopleArr property can only contain items of type \App\Insis\StructType\People, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aPeopleArr[] = $item;
        return $this;
    }
    /**
     * Get aObjectCarArr value
     * @return \App\Insis\StructType\ObjectCar[]|null
     */
    public function getAObjectCarArr()
    {
        return $this->aObjectCarArr;
    }
    /**
     * This method is responsible for validating the values passed to the setAObjectCarArr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAObjectCarArr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAObjectCarArrForArrayConstraintsFromSetAObjectCarArr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $setApplicationAObjectCarArrItem) {
            // validation for constraint: itemType
            if (!$setApplicationAObjectCarArrItem instanceof \App\Insis\StructType\ObjectCar) {
                $invalidValues[] = is_object($setApplicationAObjectCarArrItem) ? get_class($setApplicationAObjectCarArrItem) : sprintf('%s(%s)', gettype($setApplicationAObjectCarArrItem), var_export($setApplicationAObjectCarArrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aObjectCarArr property can only contain items of type \App\Insis\StructType\ObjectCar, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aObjectCarArr value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectCar[] $aObjectCarArr
     * @return \App\Insis\StructType\SetApplication
     */
    public function setAObjectCarArr(array $aObjectCarArr = array())
    {
        // validation for constraint: array
        if ('' !== ($aObjectCarArrArrayErrorMessage = self::validateAObjectCarArrForArrayConstraintsFromSetAObjectCarArr($aObjectCarArr))) {
            throw new \InvalidArgumentException($aObjectCarArrArrayErrorMessage, __LINE__);
        }
        $this->aObjectCarArr = $aObjectCarArr;
        return $this;
    }
    /**
     * Add item to aObjectCarArr value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectCar $item
     * @return \App\Insis\StructType\SetApplication
     */
    public function addToAObjectCarArr(\App\Insis\StructType\ObjectCar $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectCar) {
            throw new \InvalidArgumentException(sprintf('The aObjectCarArr property can only contain items of type \App\Insis\StructType\ObjectCar, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aObjectCarArr[] = $item;
        return $this;
    }
}
