<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestInfo StructType
 * @subpackage Structs
 */
class RequestInfo extends AbstractStructBase
{
    /**
     * The messageDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageDate;
    /**
     * The messageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageId;
    /**
     * The serviceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceId;
    /**
     * Constructor method for requestInfo
     * @uses RequestInfo::setMessageDate()
     * @uses RequestInfo::setMessageId()
     * @uses RequestInfo::setServiceId()
     * @param string $messageDate
     * @param string $messageId
     * @param string $serviceId
     */
    public function __construct($messageDate = null, $messageId = null, $serviceId = null)
    {
        $this
            ->setMessageDate($messageDate)
            ->setMessageId($messageId)
            ->setServiceId($serviceId);
    }
    /**
     * Get messageDate value
     * @return string|null
     */
    public function getMessageDate()
    {
        return $this->messageDate;
    }
    /**
     * Set messageDate value
     * @param string $messageDate
     * @return \App\Insis\StructType\RequestInfo
     */
    public function setMessageDate($messageDate = null)
    {
        // validation for constraint: string
        if (!is_null($messageDate) && !is_string($messageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageDate, true), gettype($messageDate)), __LINE__);
        }
        $this->messageDate = $messageDate;
        return $this;
    }
    /**
     * Get messageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param string $messageId
     * @return \App\Insis\StructType\RequestInfo
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get serviceId value
     * @return string|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param string $serviceId
     * @return \App\Insis\StructType\RequestInfo
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
}
