<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for renewalPolicy StructType
 * Meta information extracted from the WSDL
 * - type: tns:renewalPolicy
 * @subpackage Structs
 */
class RenewalPolicy extends AbstractStructBase
{
    /**
     * The aPolicyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aPolicyId;
    /**
     * The aBlanks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\PolicyBlanks[]
     */
    public $aBlanks;
    /**
     * The aParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $aParams;
    /**
     * Constructor method for renewalPolicy
     * @uses RenewalPolicy::setAPolicyId()
     * @uses RenewalPolicy::setABlanks()
     * @uses RenewalPolicy::setAParams()
     * @param int $aPolicyId
     * @param \App\Insis\StructType\PolicyBlanks[] $aBlanks
     * @param \App\Insis\StructType\ObjectParam[] $aParams
     */
    public function __construct($aPolicyId = null, array $aBlanks = array(), array $aParams = array())
    {
        $this
            ->setAPolicyId($aPolicyId)
            ->setABlanks($aBlanks)
            ->setAParams($aParams);
    }
    /**
     * Get aPolicyId value
     * @return int|null
     */
    public function getAPolicyId()
    {
        return $this->aPolicyId;
    }
    /**
     * Set aPolicyId value
     * @param int $aPolicyId
     * @return \App\Insis\StructType\RenewalPolicy
     */
    public function setAPolicyId($aPolicyId = null)
    {
        // validation for constraint: int
        if (!is_null($aPolicyId) && !(is_int($aPolicyId) || ctype_digit($aPolicyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aPolicyId, true), gettype($aPolicyId)), __LINE__);
        }
        $this->aPolicyId = $aPolicyId;
        return $this;
    }
    /**
     * Get aBlanks value
     * @return \App\Insis\StructType\PolicyBlanks[]|null
     */
    public function getABlanks()
    {
        return $this->aBlanks;
    }
    /**
     * This method is responsible for validating the values passed to the setABlanks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setABlanks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateABlanksForArrayConstraintsFromSetABlanks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $renewalPolicyABlanksItem) {
            // validation for constraint: itemType
            if (!$renewalPolicyABlanksItem instanceof \App\Insis\StructType\PolicyBlanks) {
                $invalidValues[] = is_object($renewalPolicyABlanksItem) ? get_class($renewalPolicyABlanksItem) : sprintf('%s(%s)', gettype($renewalPolicyABlanksItem), var_export($renewalPolicyABlanksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aBlanks property can only contain items of type \App\Insis\StructType\PolicyBlanks, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aBlanks value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyBlanks[] $aBlanks
     * @return \App\Insis\StructType\RenewalPolicy
     */
    public function setABlanks(array $aBlanks = array())
    {
        // validation for constraint: array
        if ('' !== ($aBlanksArrayErrorMessage = self::validateABlanksForArrayConstraintsFromSetABlanks($aBlanks))) {
            throw new \InvalidArgumentException($aBlanksArrayErrorMessage, __LINE__);
        }
        $this->aBlanks = $aBlanks;
        return $this;
    }
    /**
     * Add item to aBlanks value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyBlanks $item
     * @return \App\Insis\StructType\RenewalPolicy
     */
    public function addToABlanks(\App\Insis\StructType\PolicyBlanks $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\PolicyBlanks) {
            throw new \InvalidArgumentException(sprintf('The aBlanks property can only contain items of type \App\Insis\StructType\PolicyBlanks, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aBlanks[] = $item;
        return $this;
    }
    /**
     * Get aParams value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getAParams()
    {
        return $this->aParams;
    }
    /**
     * This method is responsible for validating the values passed to the setAParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAParamsForArrayConstraintsFromSetAParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $renewalPolicyAParamsItem) {
            // validation for constraint: itemType
            if (!$renewalPolicyAParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($renewalPolicyAParamsItem) ? get_class($renewalPolicyAParamsItem) : sprintf('%s(%s)', gettype($renewalPolicyAParamsItem), var_export($renewalPolicyAParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $aParams
     * @return \App\Insis\StructType\RenewalPolicy
     */
    public function setAParams(array $aParams = array())
    {
        // validation for constraint: array
        if ('' !== ($aParamsArrayErrorMessage = self::validateAParamsForArrayConstraintsFromSetAParams($aParams))) {
            throw new \InvalidArgumentException($aParamsArrayErrorMessage, __LINE__);
        }
        $this->aParams = $aParams;
        return $this;
    }
    /**
     * Add item to aParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\RenewalPolicy
     */
    public function addToAParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The aParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aParams[] = $item;
        return $this;
    }
}
