<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for policyCalls StructType
 * @subpackage Structs
 */
class PolicyCalls extends AbstractStructBase
{
    /**
     * The client
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\People
     */
    public $client;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * Constructor method for policyCalls
     * @uses PolicyCalls::setClient()
     * @uses PolicyCalls::setEndDate()
     * @uses PolicyCalls::setPolicyID()
     * @param \App\Insis\StructType\People $client
     * @param string $endDate
     * @param int $policyID
     */
    public function __construct(\App\Insis\StructType\People $client = null, $endDate = null, $policyID = null)
    {
        $this
            ->setClient($client)
            ->setEndDate($endDate)
            ->setPolicyID($policyID);
    }
    /**
     * Get client value
     * @return \App\Insis\StructType\People|null
     */
    public function getClient()
    {
        return $this->client;
    }
    /**
     * Set client value
     * @param \App\Insis\StructType\People $client
     * @return \App\Insis\StructType\PolicyCalls
     */
    public function setClient(\App\Insis\StructType\People $client = null)
    {
        $this->client = $client;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \App\Insis\StructType\PolicyCalls
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\PolicyCalls
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
}
