<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyBlanks StructType
 * @subpackage Structs
 */
class PolicyBlanks extends AbstractStructBase
{
    /**
     * The blankPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankPrefix;
    /**
     * The blankNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankNumber;
    /**
     * The blankType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankType;
    /**
     * The insrType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insrType;
    /**
     * The blankOwnerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $blankOwnerID;
    /**
     * The isAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $isAction;
    /**
     * Constructor method for PolicyBlanks
     * @uses PolicyBlanks::setBlankPrefix()
     * @uses PolicyBlanks::setBlankNumber()
     * @uses PolicyBlanks::setBlankType()
     * @uses PolicyBlanks::setInsrType()
     * @uses PolicyBlanks::setBlankOwnerID()
     * @uses PolicyBlanks::setIsAction()
     * @param string $blankPrefix
     * @param string $blankNumber
     * @param string $blankType
     * @param string $insrType
     * @param int $blankOwnerID
     * @param int $isAction
     */
    public function __construct($blankPrefix = null, $blankNumber = null, $blankType = null, $insrType = null, $blankOwnerID = null, $isAction = null)
    {
        $this
            ->setBlankPrefix($blankPrefix)
            ->setBlankNumber($blankNumber)
            ->setBlankType($blankType)
            ->setInsrType($insrType)
            ->setBlankOwnerID($blankOwnerID)
            ->setIsAction($isAction);
    }
    /**
     * Get blankPrefix value
     * @return string|null
     */
    public function getBlankPrefix()
    {
        return $this->blankPrefix;
    }
    /**
     * Set blankPrefix value
     * @param string $blankPrefix
     * @return \App\Insis\StructType\PolicyBlanks
     */
    public function setBlankPrefix($blankPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($blankPrefix) && !is_string($blankPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankPrefix, true), gettype($blankPrefix)), __LINE__);
        }
        $this->blankPrefix = $blankPrefix;
        return $this;
    }
    /**
     * Get blankNumber value
     * @return string|null
     */
    public function getBlankNumber()
    {
        return $this->blankNumber;
    }
    /**
     * Set blankNumber value
     * @param string $blankNumber
     * @return \App\Insis\StructType\PolicyBlanks
     */
    public function setBlankNumber($blankNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blankNumber) && !is_string($blankNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankNumber, true), gettype($blankNumber)), __LINE__);
        }
        $this->blankNumber = $blankNumber;
        return $this;
    }
    /**
     * Get blankType value
     * @return string|null
     */
    public function getBlankType()
    {
        return $this->blankType;
    }
    /**
     * Set blankType value
     * @param string $blankType
     * @return \App\Insis\StructType\PolicyBlanks
     */
    public function setBlankType($blankType = null)
    {
        // validation for constraint: string
        if (!is_null($blankType) && !is_string($blankType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankType, true), gettype($blankType)), __LINE__);
        }
        $this->blankType = $blankType;
        return $this;
    }
    /**
     * Get insrType value
     * @return string|null
     */
    public function getInsrType()
    {
        return $this->insrType;
    }
    /**
     * Set insrType value
     * @param string $insrType
     * @return \App\Insis\StructType\PolicyBlanks
     */
    public function setInsrType($insrType = null)
    {
        // validation for constraint: string
        if (!is_null($insrType) && !is_string($insrType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insrType, true), gettype($insrType)), __LINE__);
        }
        $this->insrType = $insrType;
        return $this;
    }
    /**
     * Get blankOwnerID value
     * @return int|null
     */
    public function getBlankOwnerID()
    {
        return $this->blankOwnerID;
    }
    /**
     * Set blankOwnerID value
     * @param int $blankOwnerID
     * @return \App\Insis\StructType\PolicyBlanks
     */
    public function setBlankOwnerID($blankOwnerID = null)
    {
        // validation for constraint: int
        if (!is_null($blankOwnerID) && !(is_int($blankOwnerID) || ctype_digit($blankOwnerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($blankOwnerID, true), gettype($blankOwnerID)), __LINE__);
        }
        $this->blankOwnerID = $blankOwnerID;
        return $this;
    }
    /**
     * Get isAction value
     * @return int|null
     */
    public function getIsAction()
    {
        return $this->isAction;
    }
    /**
     * Set isAction value
     * @param int $isAction
     * @return \App\Insis\StructType\PolicyBlanks
     */
    public function setIsAction($isAction = null)
    {
        // validation for constraint: int
        if (!is_null($isAction) && !(is_int($isAction) || ctype_digit($isAction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isAction, true), gettype($isAction)), __LINE__);
        }
        $this->isAction = $isAction;
        return $this;
    }
}
