<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The paymentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentDate;
    /**
     * The paymentAmnt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $paymentAmnt;
    /**
     * Constructor method for Payment
     * @uses Payment::setPaymentDate()
     * @uses Payment::setPaymentAmnt()
     * @param string $paymentDate
     * @param float $paymentAmnt
     */
    public function __construct($paymentDate = null, $paymentAmnt = null)
    {
        $this
            ->setPaymentDate($paymentDate)
            ->setPaymentAmnt($paymentAmnt);
    }
    /**
     * Get paymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->paymentDate;
    }
    /**
     * Set paymentDate value
     * @param string $paymentDate
     * @return \App\Insis\StructType\Payment
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->paymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get paymentAmnt value
     * @return float|null
     */
    public function getPaymentAmnt()
    {
        return $this->paymentAmnt;
    }
    /**
     * Set paymentAmnt value
     * @param float $paymentAmnt
     * @return \App\Insis\StructType\Payment
     */
    public function setPaymentAmnt($paymentAmnt = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmnt) && !(is_float($paymentAmnt) || is_numeric($paymentAmnt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmnt, true), gettype($paymentAmnt)), __LINE__);
        }
        $this->paymentAmnt = $paymentAmnt;
        return $this;
    }
}
