<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for onlineUserData StructType
 * @subpackage Structs
 */
class OnlineUserData extends AbstractStructBase
{
    /**
     * The AIIN
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AIIN;
    /**
     * The ARegNo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ARegNo;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * Constructor method for onlineUserData
     * @uses OnlineUserData::setAIIN()
     * @uses OnlineUserData::setARegNo()
     * @uses OnlineUserData::setPhone()
     * @param string[] $aIIN
     * @param string[] $aRegNo
     * @param string $phone
     */
    public function __construct(array $aIIN = array(), array $aRegNo = array(), $phone = null)
    {
        $this
            ->setAIIN($aIIN)
            ->setARegNo($aRegNo)
            ->setPhone($phone);
    }
    /**
     * Get AIIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAIIN()
    {
        return isset($this->AIIN) ? $this->AIIN : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAIIN method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAIIN method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAIINForArrayConstraintsFromSetAIIN(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlineUserDataAIINItem) {
            // validation for constraint: itemType
            if (!is_string($onlineUserDataAIINItem)) {
                $invalidValues[] = is_object($onlineUserDataAIINItem) ? get_class($onlineUserDataAIINItem) : sprintf('%s(%s)', gettype($onlineUserDataAIINItem), var_export($onlineUserDataAIINItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AIIN property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AIIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $aIIN
     * @return \App\Insis\StructType\OnlineUserData
     */
    public function setAIIN(array $aIIN = array())
    {
        // validation for constraint: array
        if ('' !== ($aIINArrayErrorMessage = self::validateAIINForArrayConstraintsFromSetAIIN($aIIN))) {
            throw new \InvalidArgumentException($aIINArrayErrorMessage, __LINE__);
        }
        if (is_null($aIIN) || (is_array($aIIN) && empty($aIIN))) {
            unset($this->AIIN);
        } else {
            $this->AIIN = $aIIN;
        }
        return $this;
    }
    /**
     * Add item to AIIN value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\OnlineUserData
     */
    public function addToAIIN($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AIIN property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AIIN[] = $item;
        return $this;
    }
    /**
     * Get ARegNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getARegNo()
    {
        return isset($this->ARegNo) ? $this->ARegNo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setARegNo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setARegNo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateARegNoForArrayConstraintsFromSetARegNo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlineUserDataARegNoItem) {
            // validation for constraint: itemType
            if (!is_string($onlineUserDataARegNoItem)) {
                $invalidValues[] = is_object($onlineUserDataARegNoItem) ? get_class($onlineUserDataARegNoItem) : sprintf('%s(%s)', gettype($onlineUserDataARegNoItem), var_export($onlineUserDataARegNoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ARegNo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ARegNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $aRegNo
     * @return \App\Insis\StructType\OnlineUserData
     */
    public function setARegNo(array $aRegNo = array())
    {
        // validation for constraint: array
        if ('' !== ($aRegNoArrayErrorMessage = self::validateARegNoForArrayConstraintsFromSetARegNo($aRegNo))) {
            throw new \InvalidArgumentException($aRegNoArrayErrorMessage, __LINE__);
        }
        if (is_null($aRegNo) || (is_array($aRegNo) && empty($aRegNo))) {
            unset($this->ARegNo);
        } else {
            $this->ARegNo = $aRegNo;
        }
        return $this;
    }
    /**
     * Add item to ARegNo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\OnlineUserData
     */
    public function addToARegNo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ARegNo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ARegNo[] = $item;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \App\Insis\StructType\OnlineUserData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
}
