<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for onlineCover StructType
 * @subpackage Structs
 */
class OnlineCover extends AbstractStructBase
{
    /**
     * The coverPremium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $coverPremium;
    /**
     * The coverPremiumCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coverPremiumCurrency;
    /**
     * The coverType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coverType;
    /**
     * The coverValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $coverValue;
    /**
     * The coverValueCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coverValueCurrency;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discount;
    /**
     * The insrType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insrType;
    /**
     * The tariff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\Tariff
     */
    public $tariff;
    /**
     * The variableParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $variableParams;
    /**
     * Constructor method for onlineCover
     * @uses OnlineCover::setCoverPremium()
     * @uses OnlineCover::setCoverPremiumCurrency()
     * @uses OnlineCover::setCoverType()
     * @uses OnlineCover::setCoverValue()
     * @uses OnlineCover::setCoverValueCurrency()
     * @uses OnlineCover::setDiscount()
     * @uses OnlineCover::setInsrType()
     * @uses OnlineCover::setTariff()
     * @uses OnlineCover::setVariableParams()
     * @param float $coverPremium
     * @param string $coverPremiumCurrency
     * @param string $coverType
     * @param float $coverValue
     * @param string $coverValueCurrency
     * @param float $discount
     * @param string $insrType
     * @param \App\Insis\StructType\Tariff $tariff
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     */
    public function __construct($coverPremium = null, $coverPremiumCurrency = null, $coverType = null, $coverValue = null, $coverValueCurrency = null, $discount = null, $insrType = null, \App\Insis\StructType\Tariff $tariff = null, array $variableParams = array())
    {
        $this
            ->setCoverPremium($coverPremium)
            ->setCoverPremiumCurrency($coverPremiumCurrency)
            ->setCoverType($coverType)
            ->setCoverValue($coverValue)
            ->setCoverValueCurrency($coverValueCurrency)
            ->setDiscount($discount)
            ->setInsrType($insrType)
            ->setTariff($tariff)
            ->setVariableParams($variableParams);
    }
    /**
     * Get coverPremium value
     * @return float|null
     */
    public function getCoverPremium()
    {
        return $this->coverPremium;
    }
    /**
     * Set coverPremium value
     * @param float $coverPremium
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setCoverPremium($coverPremium = null)
    {
        // validation for constraint: float
        if (!is_null($coverPremium) && !(is_float($coverPremium) || is_numeric($coverPremium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coverPremium, true), gettype($coverPremium)), __LINE__);
        }
        $this->coverPremium = $coverPremium;
        return $this;
    }
    /**
     * Get coverPremiumCurrency value
     * @return string|null
     */
    public function getCoverPremiumCurrency()
    {
        return $this->coverPremiumCurrency;
    }
    /**
     * Set coverPremiumCurrency value
     * @param string $coverPremiumCurrency
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setCoverPremiumCurrency($coverPremiumCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($coverPremiumCurrency) && !is_string($coverPremiumCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverPremiumCurrency, true), gettype($coverPremiumCurrency)), __LINE__);
        }
        $this->coverPremiumCurrency = $coverPremiumCurrency;
        return $this;
    }
    /**
     * Get coverType value
     * @return string|null
     */
    public function getCoverType()
    {
        return $this->coverType;
    }
    /**
     * Set coverType value
     * @param string $coverType
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setCoverType($coverType = null)
    {
        // validation for constraint: string
        if (!is_null($coverType) && !is_string($coverType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverType, true), gettype($coverType)), __LINE__);
        }
        $this->coverType = $coverType;
        return $this;
    }
    /**
     * Get coverValue value
     * @return float|null
     */
    public function getCoverValue()
    {
        return $this->coverValue;
    }
    /**
     * Set coverValue value
     * @param float $coverValue
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setCoverValue($coverValue = null)
    {
        // validation for constraint: float
        if (!is_null($coverValue) && !(is_float($coverValue) || is_numeric($coverValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coverValue, true), gettype($coverValue)), __LINE__);
        }
        $this->coverValue = $coverValue;
        return $this;
    }
    /**
     * Get coverValueCurrency value
     * @return string|null
     */
    public function getCoverValueCurrency()
    {
        return $this->coverValueCurrency;
    }
    /**
     * Set coverValueCurrency value
     * @param string $coverValueCurrency
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setCoverValueCurrency($coverValueCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($coverValueCurrency) && !is_string($coverValueCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverValueCurrency, true), gettype($coverValueCurrency)), __LINE__);
        }
        $this->coverValueCurrency = $coverValueCurrency;
        return $this;
    }
    /**
     * Get discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param float $discount
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get insrType value
     * @return string|null
     */
    public function getInsrType()
    {
        return $this->insrType;
    }
    /**
     * Set insrType value
     * @param string $insrType
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setInsrType($insrType = null)
    {
        // validation for constraint: string
        if (!is_null($insrType) && !is_string($insrType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insrType, true), gettype($insrType)), __LINE__);
        }
        $this->insrType = $insrType;
        return $this;
    }
    /**
     * Get tariff value
     * @return \App\Insis\StructType\Tariff|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param \App\Insis\StructType\Tariff $tariff
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setTariff(\App\Insis\StructType\Tariff $tariff = null)
    {
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Get variableParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getVariableParams()
    {
        return isset($this->variableParams) ? $this->variableParams : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVariableParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariableParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariableParamsForArrayConstraintsFromSetVariableParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlineCoverVariableParamsItem) {
            // validation for constraint: itemType
            if (!$onlineCoverVariableParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($onlineCoverVariableParamsItem) ? get_class($onlineCoverVariableParamsItem) : sprintf('%s(%s)', gettype($onlineCoverVariableParamsItem), var_export($onlineCoverVariableParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variableParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @return \App\Insis\StructType\OnlineCover
     */
    public function setVariableParams(array $variableParams = array())
    {
        // validation for constraint: array
        if ('' !== ($variableParamsArrayErrorMessage = self::validateVariableParamsForArrayConstraintsFromSetVariableParams($variableParams))) {
            throw new \InvalidArgumentException($variableParamsArrayErrorMessage, __LINE__);
        }
        if (is_null($variableParams) || (is_array($variableParams) && empty($variableParams))) {
            unset($this->variableParams);
        } else {
            $this->variableParams = $variableParams;
        }
        return $this;
    }
    /**
     * Add item to variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\OnlineCover
     */
    public function addToVariableParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variableParams[] = $item;
        return $this;
    }
}
