<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for objectProperty StructType
 * @subpackage Structs
 */
class ObjectProperty extends PolicyObject
{
    /**
     * The propertyKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $propertyKind;
    /**
     * The propertyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $propertyType;
    /**
     * The ownerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ownerID;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\Address
     */
    public $address;
    /**
     * Constructor method for objectProperty
     * @uses ObjectProperty::setPropertyKind()
     * @uses ObjectProperty::setPropertyType()
     * @uses ObjectProperty::setOwnerID()
     * @uses ObjectProperty::setAddress()
     * @param int $propertyKind
     * @param int $propertyType
     * @param int $ownerID
     * @param \App\Insis\StructType\Address $address
     */
    public function __construct($propertyKind = null, $propertyType = null, $ownerID = null, \App\Insis\StructType\Address $address = null)
    {
        $this
            ->setPropertyKind($propertyKind)
            ->setPropertyType($propertyType)
            ->setOwnerID($ownerID)
            ->setAddress($address);
    }
    /**
     * Get propertyKind value
     * @return int|null
     */
    public function getPropertyKind()
    {
        return $this->propertyKind;
    }
    /**
     * Set propertyKind value
     * @param int $propertyKind
     * @return \App\Insis\StructType\ObjectProperty
     */
    public function setPropertyKind($propertyKind = null)
    {
        // validation for constraint: int
        if (!is_null($propertyKind) && !(is_int($propertyKind) || ctype_digit($propertyKind))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($propertyKind, true), gettype($propertyKind)), __LINE__);
        }
        $this->propertyKind = $propertyKind;
        return $this;
    }
    /**
     * Get propertyType value
     * @return int|null
     */
    public function getPropertyType()
    {
        return $this->propertyType;
    }
    /**
     * Set propertyType value
     * @param int $propertyType
     * @return \App\Insis\StructType\ObjectProperty
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: int
        if (!is_null($propertyType) && !(is_int($propertyType) || ctype_digit($propertyType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($propertyType, true), gettype($propertyType)), __LINE__);
        }
        $this->propertyType = $propertyType;
        return $this;
    }
    /**
     * Get ownerID value
     * @return int|null
     */
    public function getOwnerID()
    {
        return $this->ownerID;
    }
    /**
     * Set ownerID value
     * @param int $ownerID
     * @return \App\Insis\StructType\ObjectProperty
     */
    public function setOwnerID($ownerID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerID) && !(is_int($ownerID) || ctype_digit($ownerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerID, true), gettype($ownerID)), __LINE__);
        }
        $this->ownerID = $ownerID;
        return $this;
    }
    /**
     * Get address value
     * @return \App\Insis\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \App\Insis\StructType\Address $address
     * @return \App\Insis\StructType\ObjectProperty
     */
    public function setAddress(\App\Insis\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
}
