<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectParam StructType
 * @subpackage Structs
 */
class ObjectParam extends AbstractStructBase
{
    /**
     * The ParamKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ParamKey;
    /**
     * The ParamValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ParamValue;
    /**
     * Constructor method for ObjectParam
     * @uses ObjectParam::setParamKey()
     * @uses ObjectParam::setParamValue()
     * @param string $paramKey
     * @param string $paramValue
     */
    public function __construct($paramKey = null, $paramValue = null)
    {
        $this
            ->setParamKey($paramKey)
            ->setParamValue($paramValue);
    }
    /**
     * Get ParamKey value
     * @return string|null
     */
    public function getParamKey()
    {
        return $this->ParamKey;
    }
    /**
     * Set ParamKey value
     * @param string $paramKey
     * @return \App\Insis\StructType\ObjectParam
     */
    public function setParamKey($paramKey = null)
    {
        // validation for constraint: string
        if (!is_null($paramKey) && !is_string($paramKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramKey, true), gettype($paramKey)), __LINE__);
        }
        $this->ParamKey = $paramKey;
        return $this;
    }
    /**
     * Get ParamValue value
     * @return string|null
     */
    public function getParamValue()
    {
        return $this->ParamValue;
    }
    /**
     * Set ParamValue value
     * @param string $paramValue
     * @return \App\Insis\StructType\ObjectParam
     */
    public function setParamValue($paramValue = null)
    {
        // validation for constraint: string
        if (!is_null($paramValue) && !is_string($paramValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramValue, true), gettype($paramValue)), __LINE__);
        }
        $this->ParamValue = $paramValue;
        return $this;
    }
}
