<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for objectLiability StructType
 * @subpackage Structs
 */
class ObjectLiability extends PolicyObject
{
    /**
     * The liabilityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $liabilityType;
    /**
     * Constructor method for objectLiability
     * @uses ObjectLiability::setLiabilityType()
     * @param int $liabilityType
     */
    public function __construct($liabilityType = null)
    {
        $this
            ->setLiabilityType($liabilityType);
    }
    /**
     * Get liabilityType value
     * @return int|null
     */
    public function getLiabilityType()
    {
        return $this->liabilityType;
    }
    /**
     * Set liabilityType value
     * @param int $liabilityType
     * @return \App\Insis\StructType\ObjectLiability
     */
    public function setLiabilityType($liabilityType = null)
    {
        // validation for constraint: int
        if (!is_null($liabilityType) && !(is_int($liabilityType) || ctype_digit($liabilityType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($liabilityType, true), gettype($liabilityType)), __LINE__);
        }
        $this->liabilityType = $liabilityType;
        return $this;
    }
}
