<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectCar StructType
 * @subpackage Structs
 */
class ObjectCar extends PolicyObject
{
    /**
     * The regNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regNumber;
    /**
     * The carType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $carType;
    /**
     * The territory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $territory;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The make
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $make;
    /**
     * The chassis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $chassis;
    /**
     * The engine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $engine;
    /**
     * The docNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docNumber;
    /**
     * The docDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docDate;
    /**
     * The editionDate
     * @var int
     */
    public $editionDate;
    /**
     * The doNotUseCSDB
     * @var bool
     */
    public $doNotUseCSDB;
    /**
     * The DocAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\Attachment[]
     */
    public $DocAttachment;
    /**
     * The VerificationBool
     * @var bool
     */
    public $VerificationBool;
    /**
     * Constructor method for ObjectCar
     * @uses ObjectCar::setRegNumber()
     * @uses ObjectCar::setCarType()
     * @uses ObjectCar::setTerritory()
     * @uses ObjectCar::setModel()
     * @uses ObjectCar::setMake()
     * @uses ObjectCar::setChassis()
     * @uses ObjectCar::setEngine()
     * @uses ObjectCar::setDocNumber()
     * @uses ObjectCar::setDocDate()
     * @uses ObjectCar::setEditionDate()
     * @uses ObjectCar::setDoNotUseCSDB()
     * @uses ObjectCar::setDocAttachment()
     * @uses ObjectCar::setVerificationBool()
     * @param string $regNumber
     * @param int $carType
     * @param string $territory
     * @param string $model
     * @param string $make
     * @param string $chassis
     * @param string $engine
     * @param string $docNumber
     * @param string $docDate
     * @param int $editionDate
     * @param bool $doNotUseCSDB
     * @param \App\Insis\StructType\Attachment[] $docAttachment
     * @param bool $verificationBool
     */
    public function __construct($regNumber = null, $carType = null, $territory = null, $model = null, $make = null, $chassis = null, $engine = null, $docNumber = null, $docDate = null, $editionDate = null, $doNotUseCSDB = null, array $docAttachment = array(), $verificationBool = null)
    {
        $this
            ->setRegNumber($regNumber)
            ->setCarType($carType)
            ->setTerritory($territory)
            ->setModel($model)
            ->setMake($make)
            ->setChassis($chassis)
            ->setEngine($engine)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setEditionDate($editionDate)
            ->setDoNotUseCSDB($doNotUseCSDB)
            ->setDocAttachment($docAttachment)
            ->setVerificationBool($verificationBool);
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regNumber, true), gettype($regNumber)), __LINE__);
        }
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get carType value
     * @return int|null
     */
    public function getCarType()
    {
        return $this->carType;
    }
    /**
     * Set carType value
     * @param int $carType
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setCarType($carType = null)
    {
        // validation for constraint: int
        if (!is_null($carType) && !(is_int($carType) || ctype_digit($carType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($carType, true), gettype($carType)), __LINE__);
        }
        $this->carType = $carType;
        return $this;
    }
    /**
     * Get territory value
     * @return string|null
     */
    public function getTerritory()
    {
        return $this->territory;
    }
    /**
     * Set territory value
     * @param string $territory
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setTerritory($territory = null)
    {
        // validation for constraint: string
        if (!is_null($territory) && !is_string($territory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($territory, true), gettype($territory)), __LINE__);
        }
        $this->territory = $territory;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($model, true), gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get make value
     * @return string|null
     */
    public function getMake()
    {
        return $this->make;
    }
    /**
     * Set make value
     * @param string $make
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setMake($make = null)
    {
        // validation for constraint: string
        if (!is_null($make) && !is_string($make)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($make, true), gettype($make)), __LINE__);
        }
        $this->make = $make;
        return $this;
    }
    /**
     * Get chassis value
     * @return string|null
     */
    public function getChassis()
    {
        return $this->chassis;
    }
    /**
     * Set chassis value
     * @param string $chassis
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setChassis($chassis = null)
    {
        // validation for constraint: string
        if (!is_null($chassis) && !is_string($chassis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chassis, true), gettype($chassis)), __LINE__);
        }
        $this->chassis = $chassis;
        return $this;
    }
    /**
     * Get engine value
     * @return string|null
     */
    public function getEngine()
    {
        return $this->engine;
    }
    /**
     * Set engine value
     * @param string $engine
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setEngine($engine = null)
    {
        // validation for constraint: string
        if (!is_null($engine) && !is_string($engine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($engine, true), gettype($engine)), __LINE__);
        }
        $this->engine = $engine;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docDate, true), gettype($docDate)), __LINE__);
        }
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get editionDate value
     * @return int|null
     */
    public function getEditionDate()
    {
        return $this->editionDate;
    }
    /**
     * Set editionDate value
     * @param int $editionDate
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setEditionDate($editionDate = null)
    {
        // validation for constraint: int
        if (!is_null($editionDate) && !(is_int($editionDate) || ctype_digit($editionDate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($editionDate, true), gettype($editionDate)), __LINE__);
        }
        $this->editionDate = $editionDate;
        return $this;
    }
    /**
     * Get doNotUseCSDB value
     * @return bool|null
     */
    public function getDoNotUseCSDB()
    {
        return $this->doNotUseCSDB;
    }
    /**
     * Set doNotUseCSDB value
     * @param bool $doNotUseCSDB
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setDoNotUseCSDB($doNotUseCSDB = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotUseCSDB) && !is_bool($doNotUseCSDB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotUseCSDB, true), gettype($doNotUseCSDB)), __LINE__);
        }
        $this->doNotUseCSDB = $doNotUseCSDB;
        return $this;
    }
    /**
     * Get DocAttachment value
     * @return \App\Insis\StructType\Attachment[]|null
     */
    public function getDocAttachment()
    {
        return $this->DocAttachment;
    }
    /**
     * This method is responsible for validating the values passed to the setDocAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocAttachmentForArrayConstraintsFromSetDocAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $objectCarDocAttachmentItem) {
            // validation for constraint: itemType
            if (!$objectCarDocAttachmentItem instanceof \App\Insis\StructType\Attachment) {
                $invalidValues[] = is_object($objectCarDocAttachmentItem) ? get_class($objectCarDocAttachmentItem) : sprintf('%s(%s)', gettype($objectCarDocAttachmentItem), var_export($objectCarDocAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocAttachment property can only contain items of type \App\Insis\StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocAttachment value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Attachment[] $docAttachment
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setDocAttachment(array $docAttachment = array())
    {
        // validation for constraint: array
        if ('' !== ($docAttachmentArrayErrorMessage = self::validateDocAttachmentForArrayConstraintsFromSetDocAttachment($docAttachment))) {
            throw new \InvalidArgumentException($docAttachmentArrayErrorMessage, __LINE__);
        }
        $this->DocAttachment = $docAttachment;
        return $this;
    }
    /**
     * Add item to DocAttachment value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Attachment $item
     * @return \App\Insis\StructType\ObjectCar
     */
    public function addToDocAttachment(\App\Insis\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The DocAttachment property can only contain items of type \App\Insis\StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocAttachment[] = $item;
        return $this;
    }
    /**
     * Get VerificationBool value
     * @return bool|null
     */
    public function getVerificationBool()
    {
        return $this->VerificationBool;
    }
    /**
     * Set VerificationBool value
     * @param bool $verificationBool
     * @return \App\Insis\StructType\ObjectCar
     */
    public function setVerificationBool($verificationBool = null)
    {
        // validation for constraint: boolean
        if (!is_null($verificationBool) && !is_bool($verificationBool)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verificationBool, true), gettype($verificationBool)), __LINE__);
        }
        $this->VerificationBool = $verificationBool;
        return $this;
    }
}
