<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for insuranceData StructType
 * @subpackage Structs
 */
class InsuranceData extends AbstractStructBase
{
    /**
     * The agent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\HcsbkAgent[]
     */
    public $agent;
    /**
     * The propertyInsurance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\PropertyInsurance[]
     */
    public $propertyInsurance;
    /**
     * The titleInsurance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\TitleInsurance[]
     */
    public $titleInsurance;
    /**
     * Constructor method for insuranceData
     * @uses InsuranceData::setAgent()
     * @uses InsuranceData::setPropertyInsurance()
     * @uses InsuranceData::setTitleInsurance()
     * @param \App\Insis\StructType\HcsbkAgent[] $agent
     * @param \App\Insis\StructType\PropertyInsurance[] $propertyInsurance
     * @param \App\Insis\StructType\TitleInsurance[] $titleInsurance
     */
    public function __construct(array $agent = array(), array $propertyInsurance = array(), array $titleInsurance = array())
    {
        $this
            ->setAgent($agent)
            ->setPropertyInsurance($propertyInsurance)
            ->setTitleInsurance($titleInsurance);
    }
    /**
     * Get agent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\HcsbkAgent[]|null
     */
    public function getAgent()
    {
        return isset($this->agent) ? $this->agent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAgent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgentForArrayConstraintsFromSetAgent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $insuranceDataAgentItem) {
            // validation for constraint: itemType
            if (!$insuranceDataAgentItem instanceof \App\Insis\StructType\HcsbkAgent) {
                $invalidValues[] = is_object($insuranceDataAgentItem) ? get_class($insuranceDataAgentItem) : sprintf('%s(%s)', gettype($insuranceDataAgentItem), var_export($insuranceDataAgentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The agent property can only contain items of type \App\Insis\StructType\HcsbkAgent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set agent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkAgent[] $agent
     * @return \App\Insis\StructType\InsuranceData
     */
    public function setAgent(array $agent = array())
    {
        // validation for constraint: array
        if ('' !== ($agentArrayErrorMessage = self::validateAgentForArrayConstraintsFromSetAgent($agent))) {
            throw new \InvalidArgumentException($agentArrayErrorMessage, __LINE__);
        }
        if (is_null($agent) || (is_array($agent) && empty($agent))) {
            unset($this->agent);
        } else {
            $this->agent = $agent;
        }
        return $this;
    }
    /**
     * Add item to agent value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\HcsbkAgent $item
     * @return \App\Insis\StructType\InsuranceData
     */
    public function addToAgent(\App\Insis\StructType\HcsbkAgent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\HcsbkAgent) {
            throw new \InvalidArgumentException(sprintf('The agent property can only contain items of type \App\Insis\StructType\HcsbkAgent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->agent[] = $item;
        return $this;
    }
    /**
     * Get propertyInsurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\PropertyInsurance[]|null
     */
    public function getPropertyInsurance()
    {
        return isset($this->propertyInsurance) ? $this->propertyInsurance : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyInsurance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyInsuranceForArrayConstraintsFromSetPropertyInsurance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $insuranceDataPropertyInsuranceItem) {
            // validation for constraint: itemType
            if (!$insuranceDataPropertyInsuranceItem instanceof \App\Insis\StructType\PropertyInsurance) {
                $invalidValues[] = is_object($insuranceDataPropertyInsuranceItem) ? get_class($insuranceDataPropertyInsuranceItem) : sprintf('%s(%s)', gettype($insuranceDataPropertyInsuranceItem), var_export($insuranceDataPropertyInsuranceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The propertyInsurance property can only contain items of type \App\Insis\StructType\PropertyInsurance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set propertyInsurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PropertyInsurance[] $propertyInsurance
     * @return \App\Insis\StructType\InsuranceData
     */
    public function setPropertyInsurance(array $propertyInsurance = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyInsuranceArrayErrorMessage = self::validatePropertyInsuranceForArrayConstraintsFromSetPropertyInsurance($propertyInsurance))) {
            throw new \InvalidArgumentException($propertyInsuranceArrayErrorMessage, __LINE__);
        }
        if (is_null($propertyInsurance) || (is_array($propertyInsurance) && empty($propertyInsurance))) {
            unset($this->propertyInsurance);
        } else {
            $this->propertyInsurance = $propertyInsurance;
        }
        return $this;
    }
    /**
     * Add item to propertyInsurance value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PropertyInsurance $item
     * @return \App\Insis\StructType\InsuranceData
     */
    public function addToPropertyInsurance(\App\Insis\StructType\PropertyInsurance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\PropertyInsurance) {
            throw new \InvalidArgumentException(sprintf('The propertyInsurance property can only contain items of type \App\Insis\StructType\PropertyInsurance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->propertyInsurance[] = $item;
        return $this;
    }
    /**
     * Get titleInsurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\TitleInsurance[]|null
     */
    public function getTitleInsurance()
    {
        return isset($this->titleInsurance) ? $this->titleInsurance : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTitleInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTitleInsurance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTitleInsuranceForArrayConstraintsFromSetTitleInsurance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $insuranceDataTitleInsuranceItem) {
            // validation for constraint: itemType
            if (!$insuranceDataTitleInsuranceItem instanceof \App\Insis\StructType\TitleInsurance) {
                $invalidValues[] = is_object($insuranceDataTitleInsuranceItem) ? get_class($insuranceDataTitleInsuranceItem) : sprintf('%s(%s)', gettype($insuranceDataTitleInsuranceItem), var_export($insuranceDataTitleInsuranceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The titleInsurance property can only contain items of type \App\Insis\StructType\TitleInsurance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set titleInsurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\TitleInsurance[] $titleInsurance
     * @return \App\Insis\StructType\InsuranceData
     */
    public function setTitleInsurance(array $titleInsurance = array())
    {
        // validation for constraint: array
        if ('' !== ($titleInsuranceArrayErrorMessage = self::validateTitleInsuranceForArrayConstraintsFromSetTitleInsurance($titleInsurance))) {
            throw new \InvalidArgumentException($titleInsuranceArrayErrorMessage, __LINE__);
        }
        if (is_null($titleInsurance) || (is_array($titleInsurance) && empty($titleInsurance))) {
            unset($this->titleInsurance);
        } else {
            $this->titleInsurance = $titleInsurance;
        }
        return $this;
    }
    /**
     * Add item to titleInsurance value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\TitleInsurance $item
     * @return \App\Insis\StructType\InsuranceData
     */
    public function addToTitleInsurance(\App\Insis\StructType\TitleInsurance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\TitleInsurance) {
            throw new \InvalidArgumentException(sprintf('The titleInsurance property can only contain items of type \App\Insis\StructType\TitleInsurance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->titleInsurance[] = $item;
        return $this;
    }
}
