<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for incomingReinsurance StructType
 * @subpackage Structs
 */
class IncomingReinsurance extends Policy
{
    /**
     * The inReinsuranceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inReinsuranceID;
    /**
     * The inReinsuranceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inReinsuranceNumber;
    /**
     * The inReinsuranceSubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inReinsuranceSubType;
    /**
     * The inReinsuranceClientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inReinsuranceClientID;
    /**
     * The inReinsuranceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $inReinsuranceValue;
    /**
     * The inReinsuranceValueCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inReinsuranceValueCurrency;
    /**
     * The inReinsuranceTariff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\Tariff
     */
    public $inReinsuranceTariff;
    /**
     * The inReinsuranceBruttoPremium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $inReinsuranceBruttoPremium;
    /**
     * The inReinsuranceNettoPremium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $inReinsuranceNettoPremium;
    /**
     * The inReinsurancePremiumCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inReinsurancePremiumCurrency;
    /**
     * The inReinsuranceComission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $inReinsuranceComission;
    /**
     * The inReinsuranceComissionCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inReinsuranceComissionCurrency;
    /**
     * The brokerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $brokerID;
    /**
     * The brokerComission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $brokerComission;
    /**
     * The inReinsuranceBorderoNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inReinsuranceBorderoNumber;
    /**
     * The reinsurers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\Reinsurer[]
     */
    public $reinsurers;
    /**
     * Constructor method for incomingReinsurance
     * @uses IncomingReinsurance::setInReinsuranceID()
     * @uses IncomingReinsurance::setInReinsuranceNumber()
     * @uses IncomingReinsurance::setInReinsuranceSubType()
     * @uses IncomingReinsurance::setInReinsuranceClientID()
     * @uses IncomingReinsurance::setInReinsuranceValue()
     * @uses IncomingReinsurance::setInReinsuranceValueCurrency()
     * @uses IncomingReinsurance::setInReinsuranceTariff()
     * @uses IncomingReinsurance::setInReinsuranceBruttoPremium()
     * @uses IncomingReinsurance::setInReinsuranceNettoPremium()
     * @uses IncomingReinsurance::setInReinsurancePremiumCurrency()
     * @uses IncomingReinsurance::setInReinsuranceComission()
     * @uses IncomingReinsurance::setInReinsuranceComissionCurrency()
     * @uses IncomingReinsurance::setBrokerID()
     * @uses IncomingReinsurance::setBrokerComission()
     * @uses IncomingReinsurance::setInReinsuranceBorderoNumber()
     * @uses IncomingReinsurance::setReinsurers()
     * @param int $inReinsuranceID
     * @param string $inReinsuranceNumber
     * @param string $inReinsuranceSubType
     * @param int $inReinsuranceClientID
     * @param float $inReinsuranceValue
     * @param string $inReinsuranceValueCurrency
     * @param \App\Insis\StructType\Tariff $inReinsuranceTariff
     * @param float $inReinsuranceBruttoPremium
     * @param float $inReinsuranceNettoPremium
     * @param string $inReinsurancePremiumCurrency
     * @param float $inReinsuranceComission
     * @param string $inReinsuranceComissionCurrency
     * @param int $brokerID
     * @param float $brokerComission
     * @param string $inReinsuranceBorderoNumber
     * @param \App\Insis\StructType\Reinsurer[] $reinsurers
     */
    public function __construct($inReinsuranceID = null, $inReinsuranceNumber = null, $inReinsuranceSubType = null, $inReinsuranceClientID = null, $inReinsuranceValue = null, $inReinsuranceValueCurrency = null, \App\Insis\StructType\Tariff $inReinsuranceTariff = null, $inReinsuranceBruttoPremium = null, $inReinsuranceNettoPremium = null, $inReinsurancePremiumCurrency = null, $inReinsuranceComission = null, $inReinsuranceComissionCurrency = null, $brokerID = null, $brokerComission = null, $inReinsuranceBorderoNumber = null, array $reinsurers = array())
    {
        $this
            ->setInReinsuranceID($inReinsuranceID)
            ->setInReinsuranceNumber($inReinsuranceNumber)
            ->setInReinsuranceSubType($inReinsuranceSubType)
            ->setInReinsuranceClientID($inReinsuranceClientID)
            ->setInReinsuranceValue($inReinsuranceValue)
            ->setInReinsuranceValueCurrency($inReinsuranceValueCurrency)
            ->setInReinsuranceTariff($inReinsuranceTariff)
            ->setInReinsuranceBruttoPremium($inReinsuranceBruttoPremium)
            ->setInReinsuranceNettoPremium($inReinsuranceNettoPremium)
            ->setInReinsurancePremiumCurrency($inReinsurancePremiumCurrency)
            ->setInReinsuranceComission($inReinsuranceComission)
            ->setInReinsuranceComissionCurrency($inReinsuranceComissionCurrency)
            ->setBrokerID($brokerID)
            ->setBrokerComission($brokerComission)
            ->setInReinsuranceBorderoNumber($inReinsuranceBorderoNumber)
            ->setReinsurers($reinsurers);
    }
    /**
     * Get inReinsuranceID value
     * @return int|null
     */
    public function getInReinsuranceID()
    {
        return $this->inReinsuranceID;
    }
    /**
     * Set inReinsuranceID value
     * @param int $inReinsuranceID
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceID($inReinsuranceID = null)
    {
        // validation for constraint: int
        if (!is_null($inReinsuranceID) && !(is_int($inReinsuranceID) || ctype_digit($inReinsuranceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inReinsuranceID, true), gettype($inReinsuranceID)), __LINE__);
        }
        $this->inReinsuranceID = $inReinsuranceID;
        return $this;
    }
    /**
     * Get inReinsuranceNumber value
     * @return string|null
     */
    public function getInReinsuranceNumber()
    {
        return $this->inReinsuranceNumber;
    }
    /**
     * Set inReinsuranceNumber value
     * @param string $inReinsuranceNumber
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceNumber($inReinsuranceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($inReinsuranceNumber) && !is_string($inReinsuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inReinsuranceNumber, true), gettype($inReinsuranceNumber)), __LINE__);
        }
        $this->inReinsuranceNumber = $inReinsuranceNumber;
        return $this;
    }
    /**
     * Get inReinsuranceSubType value
     * @return string|null
     */
    public function getInReinsuranceSubType()
    {
        return $this->inReinsuranceSubType;
    }
    /**
     * Set inReinsuranceSubType value
     * @param string $inReinsuranceSubType
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceSubType($inReinsuranceSubType = null)
    {
        // validation for constraint: string
        if (!is_null($inReinsuranceSubType) && !is_string($inReinsuranceSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inReinsuranceSubType, true), gettype($inReinsuranceSubType)), __LINE__);
        }
        $this->inReinsuranceSubType = $inReinsuranceSubType;
        return $this;
    }
    /**
     * Get inReinsuranceClientID value
     * @return int|null
     */
    public function getInReinsuranceClientID()
    {
        return $this->inReinsuranceClientID;
    }
    /**
     * Set inReinsuranceClientID value
     * @param int $inReinsuranceClientID
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceClientID($inReinsuranceClientID = null)
    {
        // validation for constraint: int
        if (!is_null($inReinsuranceClientID) && !(is_int($inReinsuranceClientID) || ctype_digit($inReinsuranceClientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inReinsuranceClientID, true), gettype($inReinsuranceClientID)), __LINE__);
        }
        $this->inReinsuranceClientID = $inReinsuranceClientID;
        return $this;
    }
    /**
     * Get inReinsuranceValue value
     * @return float|null
     */
    public function getInReinsuranceValue()
    {
        return $this->inReinsuranceValue;
    }
    /**
     * Set inReinsuranceValue value
     * @param float $inReinsuranceValue
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceValue($inReinsuranceValue = null)
    {
        // validation for constraint: float
        if (!is_null($inReinsuranceValue) && !(is_float($inReinsuranceValue) || is_numeric($inReinsuranceValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inReinsuranceValue, true), gettype($inReinsuranceValue)), __LINE__);
        }
        $this->inReinsuranceValue = $inReinsuranceValue;
        return $this;
    }
    /**
     * Get inReinsuranceValueCurrency value
     * @return string|null
     */
    public function getInReinsuranceValueCurrency()
    {
        return $this->inReinsuranceValueCurrency;
    }
    /**
     * Set inReinsuranceValueCurrency value
     * @param string $inReinsuranceValueCurrency
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceValueCurrency($inReinsuranceValueCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($inReinsuranceValueCurrency) && !is_string($inReinsuranceValueCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inReinsuranceValueCurrency, true), gettype($inReinsuranceValueCurrency)), __LINE__);
        }
        $this->inReinsuranceValueCurrency = $inReinsuranceValueCurrency;
        return $this;
    }
    /**
     * Get inReinsuranceTariff value
     * @return \App\Insis\StructType\Tariff|null
     */
    public function getInReinsuranceTariff()
    {
        return $this->inReinsuranceTariff;
    }
    /**
     * Set inReinsuranceTariff value
     * @param \App\Insis\StructType\Tariff $inReinsuranceTariff
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceTariff(\App\Insis\StructType\Tariff $inReinsuranceTariff = null)
    {
        $this->inReinsuranceTariff = $inReinsuranceTariff;
        return $this;
    }
    /**
     * Get inReinsuranceBruttoPremium value
     * @return float|null
     */
    public function getInReinsuranceBruttoPremium()
    {
        return $this->inReinsuranceBruttoPremium;
    }
    /**
     * Set inReinsuranceBruttoPremium value
     * @param float $inReinsuranceBruttoPremium
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceBruttoPremium($inReinsuranceBruttoPremium = null)
    {
        // validation for constraint: float
        if (!is_null($inReinsuranceBruttoPremium) && !(is_float($inReinsuranceBruttoPremium) || is_numeric($inReinsuranceBruttoPremium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inReinsuranceBruttoPremium, true), gettype($inReinsuranceBruttoPremium)), __LINE__);
        }
        $this->inReinsuranceBruttoPremium = $inReinsuranceBruttoPremium;
        return $this;
    }
    /**
     * Get inReinsuranceNettoPremium value
     * @return float|null
     */
    public function getInReinsuranceNettoPremium()
    {
        return $this->inReinsuranceNettoPremium;
    }
    /**
     * Set inReinsuranceNettoPremium value
     * @param float $inReinsuranceNettoPremium
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceNettoPremium($inReinsuranceNettoPremium = null)
    {
        // validation for constraint: float
        if (!is_null($inReinsuranceNettoPremium) && !(is_float($inReinsuranceNettoPremium) || is_numeric($inReinsuranceNettoPremium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inReinsuranceNettoPremium, true), gettype($inReinsuranceNettoPremium)), __LINE__);
        }
        $this->inReinsuranceNettoPremium = $inReinsuranceNettoPremium;
        return $this;
    }
    /**
     * Get inReinsurancePremiumCurrency value
     * @return string|null
     */
    public function getInReinsurancePremiumCurrency()
    {
        return $this->inReinsurancePremiumCurrency;
    }
    /**
     * Set inReinsurancePremiumCurrency value
     * @param string $inReinsurancePremiumCurrency
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsurancePremiumCurrency($inReinsurancePremiumCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($inReinsurancePremiumCurrency) && !is_string($inReinsurancePremiumCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inReinsurancePremiumCurrency, true), gettype($inReinsurancePremiumCurrency)), __LINE__);
        }
        $this->inReinsurancePremiumCurrency = $inReinsurancePremiumCurrency;
        return $this;
    }
    /**
     * Get inReinsuranceComission value
     * @return float|null
     */
    public function getInReinsuranceComission()
    {
        return $this->inReinsuranceComission;
    }
    /**
     * Set inReinsuranceComission value
     * @param float $inReinsuranceComission
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceComission($inReinsuranceComission = null)
    {
        // validation for constraint: float
        if (!is_null($inReinsuranceComission) && !(is_float($inReinsuranceComission) || is_numeric($inReinsuranceComission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inReinsuranceComission, true), gettype($inReinsuranceComission)), __LINE__);
        }
        $this->inReinsuranceComission = $inReinsuranceComission;
        return $this;
    }
    /**
     * Get inReinsuranceComissionCurrency value
     * @return string|null
     */
    public function getInReinsuranceComissionCurrency()
    {
        return $this->inReinsuranceComissionCurrency;
    }
    /**
     * Set inReinsuranceComissionCurrency value
     * @param string $inReinsuranceComissionCurrency
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceComissionCurrency($inReinsuranceComissionCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($inReinsuranceComissionCurrency) && !is_string($inReinsuranceComissionCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inReinsuranceComissionCurrency, true), gettype($inReinsuranceComissionCurrency)), __LINE__);
        }
        $this->inReinsuranceComissionCurrency = $inReinsuranceComissionCurrency;
        return $this;
    }
    /**
     * Get brokerID value
     * @return int|null
     */
    public function getBrokerID()
    {
        return $this->brokerID;
    }
    /**
     * Set brokerID value
     * @param int $brokerID
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setBrokerID($brokerID = null)
    {
        // validation for constraint: int
        if (!is_null($brokerID) && !(is_int($brokerID) || ctype_digit($brokerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brokerID, true), gettype($brokerID)), __LINE__);
        }
        $this->brokerID = $brokerID;
        return $this;
    }
    /**
     * Get brokerComission value
     * @return float|null
     */
    public function getBrokerComission()
    {
        return $this->brokerComission;
    }
    /**
     * Set brokerComission value
     * @param float $brokerComission
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setBrokerComission($brokerComission = null)
    {
        // validation for constraint: float
        if (!is_null($brokerComission) && !(is_float($brokerComission) || is_numeric($brokerComission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($brokerComission, true), gettype($brokerComission)), __LINE__);
        }
        $this->brokerComission = $brokerComission;
        return $this;
    }
    /**
     * Get inReinsuranceBorderoNumber value
     * @return string|null
     */
    public function getInReinsuranceBorderoNumber()
    {
        return $this->inReinsuranceBorderoNumber;
    }
    /**
     * Set inReinsuranceBorderoNumber value
     * @param string $inReinsuranceBorderoNumber
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setInReinsuranceBorderoNumber($inReinsuranceBorderoNumber = null)
    {
        // validation for constraint: string
        if (!is_null($inReinsuranceBorderoNumber) && !is_string($inReinsuranceBorderoNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inReinsuranceBorderoNumber, true), gettype($inReinsuranceBorderoNumber)), __LINE__);
        }
        $this->inReinsuranceBorderoNumber = $inReinsuranceBorderoNumber;
        return $this;
    }
    /**
     * Get reinsurers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\Reinsurer[]|null
     */
    public function getReinsurers()
    {
        return isset($this->reinsurers) ? $this->reinsurers : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReinsurers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReinsurers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReinsurersForArrayConstraintsFromSetReinsurers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $incomingReinsuranceReinsurersItem) {
            // validation for constraint: itemType
            if (!$incomingReinsuranceReinsurersItem instanceof \App\Insis\StructType\Reinsurer) {
                $invalidValues[] = is_object($incomingReinsuranceReinsurersItem) ? get_class($incomingReinsuranceReinsurersItem) : sprintf('%s(%s)', gettype($incomingReinsuranceReinsurersItem), var_export($incomingReinsuranceReinsurersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The reinsurers property can only contain items of type \App\Insis\StructType\Reinsurer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set reinsurers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Reinsurer[] $reinsurers
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function setReinsurers(array $reinsurers = array())
    {
        // validation for constraint: array
        if ('' !== ($reinsurersArrayErrorMessage = self::validateReinsurersForArrayConstraintsFromSetReinsurers($reinsurers))) {
            throw new \InvalidArgumentException($reinsurersArrayErrorMessage, __LINE__);
        }
        if (is_null($reinsurers) || (is_array($reinsurers) && empty($reinsurers))) {
            unset($this->reinsurers);
        } else {
            $this->reinsurers = $reinsurers;
        }
        return $this;
    }
    /**
     * Add item to reinsurers value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Reinsurer $item
     * @return \App\Insis\StructType\IncomingReinsurance
     */
    public function addToReinsurers(\App\Insis\StructType\Reinsurer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Reinsurer) {
            throw new \InvalidArgumentException(sprintf('The reinsurers property can only contain items of type \App\Insis\StructType\Reinsurer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->reinsurers[] = $item;
        return $this;
    }
}
