<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hcsbkBank StructType
 * @subpackage Structs
 */
class HcsbkBank extends AbstractStructBase
{
    /**
     * The bik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bik;
    /**
     * The bin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bin;
    /**
     * The iik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iik;
    /**
     * The isResident
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $isResident;
    /**
     * The kbe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kbe;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The sectorEconom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sectorEconom;
    /**
     * Constructor method for hcsbkBank
     * @uses HcsbkBank::setBik()
     * @uses HcsbkBank::setBin()
     * @uses HcsbkBank::setIik()
     * @uses HcsbkBank::setIsResident()
     * @uses HcsbkBank::setKbe()
     * @uses HcsbkBank::setName()
     * @uses HcsbkBank::setSectorEconom()
     * @param string $bik
     * @param string $bin
     * @param string $iik
     * @param int $isResident
     * @param string $kbe
     * @param string $name
     * @param string $sectorEconom
     */
    public function __construct($bik = null, $bin = null, $iik = null, $isResident = null, $kbe = null, $name = null, $sectorEconom = null)
    {
        $this
            ->setBik($bik)
            ->setBin($bin)
            ->setIik($iik)
            ->setIsResident($isResident)
            ->setKbe($kbe)
            ->setName($name)
            ->setSectorEconom($sectorEconom);
    }
    /**
     * Get bik value
     * @return string|null
     */
    public function getBik()
    {
        return $this->bik;
    }
    /**
     * Set bik value
     * @param string $bik
     * @return \App\Insis\StructType\HcsbkBank
     */
    public function setBik($bik = null)
    {
        // validation for constraint: string
        if (!is_null($bik) && !is_string($bik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bik, true), gettype($bik)), __LINE__);
        }
        $this->bik = $bik;
        return $this;
    }
    /**
     * Get bin value
     * @return string|null
     */
    public function getBin()
    {
        return $this->bin;
    }
    /**
     * Set bin value
     * @param string $bin
     * @return \App\Insis\StructType\HcsbkBank
     */
    public function setBin($bin = null)
    {
        // validation for constraint: string
        if (!is_null($bin) && !is_string($bin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin, true), gettype($bin)), __LINE__);
        }
        $this->bin = $bin;
        return $this;
    }
    /**
     * Get iik value
     * @return string|null
     */
    public function getIik()
    {
        return $this->iik;
    }
    /**
     * Set iik value
     * @param string $iik
     * @return \App\Insis\StructType\HcsbkBank
     */
    public function setIik($iik = null)
    {
        // validation for constraint: string
        if (!is_null($iik) && !is_string($iik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iik, true), gettype($iik)), __LINE__);
        }
        $this->iik = $iik;
        return $this;
    }
    /**
     * Get isResident value
     * @return int|null
     */
    public function getIsResident()
    {
        return $this->isResident;
    }
    /**
     * Set isResident value
     * @param int $isResident
     * @return \App\Insis\StructType\HcsbkBank
     */
    public function setIsResident($isResident = null)
    {
        // validation for constraint: int
        if (!is_null($isResident) && !(is_int($isResident) || ctype_digit($isResident))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isResident, true), gettype($isResident)), __LINE__);
        }
        $this->isResident = $isResident;
        return $this;
    }
    /**
     * Get kbe value
     * @return string|null
     */
    public function getKbe()
    {
        return $this->kbe;
    }
    /**
     * Set kbe value
     * @param string $kbe
     * @return \App\Insis\StructType\HcsbkBank
     */
    public function setKbe($kbe = null)
    {
        // validation for constraint: string
        if (!is_null($kbe) && !is_string($kbe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kbe, true), gettype($kbe)), __LINE__);
        }
        $this->kbe = $kbe;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Insis\StructType\HcsbkBank
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sectorEconom value
     * @return string|null
     */
    public function getSectorEconom()
    {
        return $this->sectorEconom;
    }
    /**
     * Set sectorEconom value
     * @param string $sectorEconom
     * @return \App\Insis\StructType\HcsbkBank
     */
    public function setSectorEconom($sectorEconom = null)
    {
        // validation for constraint: string
        if (!is_null($sectorEconom) && !is_string($sectorEconom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorEconom, true), gettype($sectorEconom)), __LINE__);
        }
        $this->sectorEconom = $sectorEconom;
        return $this;
    }
}
