<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrintForm StructType
 * Meta information extracted from the WSDL
 * - type: tns:getPrintForm
 * @subpackage Structs
 */
class GetPrintForm extends AbstractStructBase
{
    /**
     * The aPrintType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aPrintType;
    /**
     * The aPrintGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aPrintGroup;
    /**
     * The aPrintParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $aPrintParams;
    /**
     * Constructor method for getPrintForm
     * @uses GetPrintForm::setAPrintType()
     * @uses GetPrintForm::setAPrintGroup()
     * @uses GetPrintForm::setAPrintParams()
     * @param int $aPrintType
     * @param string $aPrintGroup
     * @param \App\Insis\StructType\ObjectParam[] $aPrintParams
     */
    public function __construct($aPrintType = null, $aPrintGroup = null, array $aPrintParams = array())
    {
        $this
            ->setAPrintType($aPrintType)
            ->setAPrintGroup($aPrintGroup)
            ->setAPrintParams($aPrintParams);
    }
    /**
     * Get aPrintType value
     * @return int|null
     */
    public function getAPrintType()
    {
        return $this->aPrintType;
    }
    /**
     * Set aPrintType value
     * @param int $aPrintType
     * @return \App\Insis\StructType\GetPrintForm
     */
    public function setAPrintType($aPrintType = null)
    {
        // validation for constraint: int
        if (!is_null($aPrintType) && !(is_int($aPrintType) || ctype_digit($aPrintType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aPrintType, true), gettype($aPrintType)), __LINE__);
        }
        $this->aPrintType = $aPrintType;
        return $this;
    }
    /**
     * Get aPrintGroup value
     * @return string|null
     */
    public function getAPrintGroup()
    {
        return $this->aPrintGroup;
    }
    /**
     * Set aPrintGroup value
     * @param string $aPrintGroup
     * @return \App\Insis\StructType\GetPrintForm
     */
    public function setAPrintGroup($aPrintGroup = null)
    {
        // validation for constraint: string
        if (!is_null($aPrintGroup) && !is_string($aPrintGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPrintGroup, true), gettype($aPrintGroup)), __LINE__);
        }
        $this->aPrintGroup = $aPrintGroup;
        return $this;
    }
    /**
     * Get aPrintParams value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getAPrintParams()
    {
        return $this->aPrintParams;
    }
    /**
     * This method is responsible for validating the values passed to the setAPrintParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAPrintParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAPrintParamsForArrayConstraintsFromSetAPrintParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPrintFormAPrintParamsItem) {
            // validation for constraint: itemType
            if (!$getPrintFormAPrintParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($getPrintFormAPrintParamsItem) ? get_class($getPrintFormAPrintParamsItem) : sprintf('%s(%s)', gettype($getPrintFormAPrintParamsItem), var_export($getPrintFormAPrintParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aPrintParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aPrintParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $aPrintParams
     * @return \App\Insis\StructType\GetPrintForm
     */
    public function setAPrintParams(array $aPrintParams = array())
    {
        // validation for constraint: array
        if ('' !== ($aPrintParamsArrayErrorMessage = self::validateAPrintParamsForArrayConstraintsFromSetAPrintParams($aPrintParams))) {
            throw new \InvalidArgumentException($aPrintParamsArrayErrorMessage, __LINE__);
        }
        $this->aPrintParams = $aPrintParams;
        return $this;
    }
    /**
     * Add item to aPrintParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\GetPrintForm
     */
    public function addToAPrintParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The aPrintParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aPrintParams[] = $item;
        return $this;
    }
}
