<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBoxPremiumByIIN StructType
 * Meta information extracted from the WSDL
 * - type: tns:getBoxPremiumByIIN
 * @subpackage Structs
 */
class GetBoxPremiumByIIN extends AbstractStructBase
{
    /**
     * The InsrType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsrType;
    /**
     * The IIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IIN;
    /**
     * Constructor method for getBoxPremiumByIIN
     * @uses GetBoxPremiumByIIN::setInsrType()
     * @uses GetBoxPremiumByIIN::setIIN()
     * @param string $insrType
     * @param string $iIN
     */
    public function __construct($insrType = null, $iIN = null)
    {
        $this
            ->setInsrType($insrType)
            ->setIIN($iIN);
    }
    /**
     * Get InsrType value
     * @return string|null
     */
    public function getInsrType()
    {
        return $this->InsrType;
    }
    /**
     * Set InsrType value
     * @param string $insrType
     * @return \App\Insis\StructType\GetBoxPremiumByIIN
     */
    public function setInsrType($insrType = null)
    {
        // validation for constraint: string
        if (!is_null($insrType) && !is_string($insrType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insrType, true), gettype($insrType)), __LINE__);
        }
        $this->InsrType = $insrType;
        return $this;
    }
    /**
     * Get IIN value
     * @return string|null
     */
    public function getIIN()
    {
        return $this->IIN;
    }
    /**
     * Set IIN value
     * @param string $iIN
     * @return \App\Insis\StructType\GetBoxPremiumByIIN
     */
    public function setIIN($iIN = null)
    {
        // validation for constraint: string
        if (!is_null($iIN) && !is_string($iIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iIN, true), gettype($iIN)), __LINE__);
        }
        $this->IIN = $iIN;
        return $this;
    }
}
