<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Distribution StructType
 * @subpackage Structs
 */
class Distribution extends AbstractStructBase
{
    /**
     * The type
     * @var int
     */
    public $type;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The text
     * @var string
     */
    public $text;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * Constructor method for Distribution
     * @uses Distribution::setType()
     * @uses Distribution::setName()
     * @uses Distribution::setText()
     * @uses Distribution::setDestination()
     * @param int $type
     * @param string $name
     * @param string $text
     * @param string $destination
     */
    public function __construct($type = null, $name = null, $text = null, $destination = null)
    {
        $this
            ->setType($type)
            ->setName($name)
            ->setText($text)
            ->setDestination($destination);
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \App\Insis\StructType\Distribution
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Insis\StructType\Distribution
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \App\Insis\StructType\Distribution
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \App\Insis\StructType\Distribution
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
}
